/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.logging;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;

public final class RegexBasedSanitizer
implements BiFunction<RequestContext, Object, String> {
    private final List<Pattern> patterns;

    public static RegexBasedSanitizer of(Pattern ... patterns) {
        Objects.requireNonNull(patterns, "patterns");
        return new RegexBasedSanitizer(ImmutableList.copyOf(patterns));
    }

    public static RegexBasedSanitizer of(Iterable<Pattern> patterns) {
        Objects.requireNonNull(patterns, "patterns");
        return new RegexBasedSanitizer(ImmutableList.copyOf(patterns));
    }

    RegexBasedSanitizer(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    @Nullable
    public String apply(RequestContext ctx, @Nullable Object input) {
        if (input == null) {
            return null;
        }
        String rawData = input.toString();
        for (Pattern pattern : this.patterns) {
            Matcher m = pattern.matcher(rawData);
            rawData = m.replaceAll("");
        }
        return rawData;
    }
}

