/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.BuiltInProperty;
import karate.com.linecorp.armeria.common.logging.ExportGroup;
import karate.com.linecorp.armeria.common.logging.ExportGroupBuilder;
import karate.com.linecorp.armeria.common.logging.RequestContextExporter;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.io.netty.util.AsciiString;
import karate.io.netty.util.AttributeKey;

public final class RequestContextExporterBuilder {
    private final ExportGroupBuilder defaultExportGroupBuilder = ExportGroup.builder();
    @Nullable
    private List<ExportGroup> exportGroups;

    RequestContextExporterBuilder() {
    }

    public RequestContextExporterBuilder builtIn(BuiltInProperty property) {
        Objects.requireNonNull(property, "property");
        return this.builtIn(property, property.key);
    }

    public RequestContextExporterBuilder builtIn(BuiltInProperty property, String alias) {
        Objects.requireNonNull(property, "property");
        Objects.requireNonNull(alias, "alias");
        this.defaultExportGroupBuilder.builtIn(property, alias);
        return this;
    }

    public RequestContextExporterBuilder attr(String alias, AttributeKey<?> attrKey) {
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(attrKey, "attrKey");
        this.defaultExportGroupBuilder.attr(alias, attrKey);
        return this;
    }

    public RequestContextExporterBuilder attr(String alias, AttributeKey<?> attrKey, Function<?, String> stringifier) {
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(attrKey, "attrKey");
        Objects.requireNonNull(stringifier, "stringifier");
        this.defaultExportGroupBuilder.attr(alias, attrKey, stringifier);
        return this;
    }

    public RequestContextExporterBuilder requestHeader(CharSequence headerName) {
        Objects.requireNonNull(headerName, "headerName");
        this.defaultExportGroupBuilder.requestHeader(headerName);
        return this;
    }

    public RequestContextExporterBuilder requestHeader(CharSequence headerName, String alias) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(alias, "alias");
        this.defaultExportGroupBuilder.requestHeader(headerName, alias);
        return this;
    }

    public RequestContextExporterBuilder responseHeader(CharSequence headerName) {
        Objects.requireNonNull(headerName, "headerName");
        this.defaultExportGroupBuilder.responseHeader(headerName);
        return this;
    }

    public RequestContextExporterBuilder responseHeader(CharSequence headerName, String alias) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(alias, "alias");
        this.defaultExportGroupBuilder.responseHeader(headerName, alias);
        return this;
    }

    public RequestContextExporterBuilder prefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        Preconditions.checkArgument(!prefix.isEmpty(), "prefix must not be empty");
        this.defaultExportGroupBuilder.prefix(prefix);
        return this;
    }

    public RequestContextExporterBuilder keyPattern(String keyPattern) {
        Objects.requireNonNull(keyPattern, "keyPattern");
        Preconditions.checkArgument(!keyPattern.isEmpty(), "keyPattern must not be empty");
        this.defaultExportGroupBuilder.keyPattern(keyPattern);
        return this;
    }

    public RequestContextExporterBuilder exportGroup(ExportGroup exportGroup) {
        if (this.exportGroups == null) {
            this.exportGroups = new ArrayList<ExportGroup>();
        }
        this.exportGroups.add(exportGroup);
        return this;
    }

    public RequestContextExporter build() {
        if (this.exportGroups == null) {
            ExportGroup defaultExportGroup = this.defaultExportGroupBuilder.build();
            return new RequestContextExporter(defaultExportGroup.builtIns(), defaultExportGroup.attrs(), defaultExportGroup.reqHeaders(), defaultExportGroup.resHeaders());
        }
        ImmutableSet.Builder builtInProperties = ImmutableSet.builder();
        ImmutableSet.Builder attrs = ImmutableSet.builder();
        ImmutableSet.Builder reqHeaders = ImmutableSet.builder();
        ImmutableSet.Builder resHeaders = ImmutableSet.builder();
        ArrayList<ExportGroup> exportGroupList = new ArrayList<ExportGroup>(this.exportGroups);
        exportGroupList.add(this.defaultExportGroupBuilder.build());
        for (ExportGroup exportGroup : exportGroupList) {
            builtInProperties.addAll(exportGroup.builtIns());
            attrs.addAll(exportGroup.attrs());
            reqHeaders.addAll(exportGroup.reqHeaders());
            resHeaders.addAll(exportGroup.resHeaders());
        }
        return new RequestContextExporter((Set<ExportGroupBuilder.ExportEntry<BuiltInProperty>>)((Object)builtInProperties.build()), (Set<ExportGroupBuilder.ExportEntry<AttributeKey<?>>>)((Object)attrs.build()), (Set<ExportGroupBuilder.ExportEntry<AsciiString>>)((Object)reqHeaders.build()), (Set<ExportGroupBuilder.ExportEntry<AsciiString>>)((Object)resHeaders.build()));
    }
}

