/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.logging;

import java.util.Arrays;
import java.util.Set;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Sets;

public enum RequestLogProperty {
    REQUEST_START_TIME(true),
    REQUEST_END_TIME(true),
    REQUEST_FIRST_BYTES_TRANSFERRED_TIME(true),
    SESSION(true),
    SCHEME(true),
    NAME(true),
    AUTHENTICATED_USER(true),
    REQUEST_HEADERS(true),
    REQUEST_CONTENT(true),
    REQUEST_CONTENT_PREVIEW(true),
    REQUEST_TRAILERS(true),
    REQUEST_LENGTH(true),
    REQUEST_CAUSE(true),
    RESPONSE_START_TIME(false),
    RESPONSE_END_TIME(false),
    RESPONSE_FIRST_BYTES_TRANSFERRED_TIME(false),
    RESPONSE_HEADERS(false),
    RESPONSE_CONTENT(false),
    RESPONSE_CONTENT_PREVIEW(false),
    RESPONSE_TRAILERS(false),
    RESPONSE_LENGTH(false),
    RESPONSE_CAUSE(false);

    private static final Set<RequestLogProperty> REQUEST_PROPERTIES;
    private static final Set<RequestLogProperty> RESPONSE_PROPERTIES;
    private static final Set<RequestLogProperty> ALL_PROPERTIES;
    static final int FLAGS_REQUEST_COMPLETE;
    static final int FLAGS_RESPONSE_COMPLETE;
    static final int FLAGS_ALL_COMPLETE;
    private final int flag;
    private final boolean isRequestProperty;

    public static Set<RequestLogProperty> requestProperties() {
        return REQUEST_PROPERTIES;
    }

    public static Set<RequestLogProperty> responseProperties() {
        return RESPONSE_PROPERTIES;
    }

    public static Set<RequestLogProperty> allProperties() {
        return ALL_PROPERTIES;
    }

    public boolean isAvailable(int flags) {
        return (this.flag & flags) != 0;
    }

    static int flags(RequestLogProperty ... properties) {
        int flags = 0;
        for (RequestLogProperty property : properties) {
            flags |= property.flag();
        }
        return flags;
    }

    static int flags(Iterable<RequestLogProperty> properties) {
        int flags = 0;
        for (RequestLogProperty property : properties) {
            flags |= property.flag();
        }
        return flags;
    }

    private RequestLogProperty(boolean isRequestProperty) {
        Preconditions.checkState(this.ordinal() <= 30, "More than 31 properties defined. Please switch all 'flags' to long and update this check to 62.");
        this.flag = 1 << this.ordinal();
        this.isRequestProperty = isRequestProperty;
    }

    int flag() {
        return this.flag;
    }

    static {
        REQUEST_PROPERTIES = Arrays.stream(RequestLogProperty.values()).filter(p -> p.isRequestProperty).collect(Sets.toImmutableEnumSet());
        RESPONSE_PROPERTIES = Arrays.stream(RequestLogProperty.values()).filter(p -> !p.isRequestProperty).collect(Sets.toImmutableEnumSet());
        ALL_PROPERTIES = Arrays.stream(RequestLogProperty.values()).collect(Sets.toImmutableEnumSet());
        FLAGS_REQUEST_COMPLETE = RequestLogProperty.flags(REQUEST_PROPERTIES);
        FLAGS_RESPONSE_COMPLETE = RequestLogProperty.flags(RESPONSE_PROPERTIES);
        FLAGS_ALL_COMPLETE = FLAGS_REQUEST_COMPLETE | FLAGS_RESPONSE_COMPLETE;
    }
}

