/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.logging;

import java.util.function.BiFunction;
import javax.net.ssl.SSLSession;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.Scheme;
import karate.com.linecorp.armeria.common.SerializationFormat;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.ClientConnectionTimings;
import karate.com.linecorp.armeria.common.logging.LogFormatter;
import karate.com.linecorp.armeria.common.logging.RequestLogAccess;
import karate.com.linecorp.armeria.common.logging.TextLogFormatterBuilder;
import karate.com.linecorp.armeria.common.util.Functions;
import karate.io.netty.channel.Channel;

public interface RequestOnlyLog
extends RequestLogAccess {
    public long requestStartTimeMicros();

    public long requestStartTimeMillis();

    public long requestStartTimeNanos();

    @Nullable
    public Long requestFirstBytesTransferredTimeNanos();

    public long requestEndTimeNanos();

    default public long requestDurationNanos() {
        return this.requestEndTimeNanos() - this.requestStartTimeNanos();
    }

    public long requestLength();

    @Nullable
    public Throwable requestCause();

    @Nullable
    public Channel channel();

    @Nullable
    public SSLSession sslSession();

    public SessionProtocol sessionProtocol();

    @Nullable
    public ClientConnectionTimings connectionTimings();

    public SerializationFormat serializationFormat();

    public Scheme scheme();

    @Nullable
    public String serviceName();

    public String name();

    public String fullName();

    @Nullable
    public String authenticatedUser();

    public RequestHeaders requestHeaders();

    @Nullable
    public Object requestContent();

    @Nullable
    public Object rawRequestContent();

    @Nullable
    public String requestContentPreview();

    public HttpHeaders requestTrailers();

    public int currentAttempt();

    @Deprecated
    default public String toStringRequestOnly() {
        return this.toStringRequestOnly(Functions.second(), Functions.second(), Functions.second());
    }

    @Deprecated
    default public String toStringRequestOnly(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> headersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> contentSanitizer) {
        return this.toStringRequestOnly(headersSanitizer, contentSanitizer, headersSanitizer);
    }

    @Deprecated
    default public String toStringRequestOnly(BiFunction<? super RequestContext, ? super RequestHeaders, ? extends @Nullable Object> headersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> contentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> trailersSanitizer) {
        return ((TextLogFormatterBuilder)((TextLogFormatterBuilder)((TextLogFormatterBuilder)LogFormatter.builderForText().requestHeadersSanitizer((ctx, headers) -> {
            RequestHeaders requestHeaders = (RequestHeaders)headers;
            Object sanitized = headersSanitizer.apply((RequestContext)ctx, requestHeaders);
            if (sanitized == null) {
                return "<sanitized>";
            }
            return sanitized.toString();
        })).requestTrailersSanitizer((ctx, headers) -> {
            Object sanitized = trailersSanitizer.apply((RequestContext)ctx, (HttpHeaders)headers);
            if (sanitized == null) {
                return "<sanitized>";
            }
            return sanitized.toString();
        })).requestContentSanitizer((ctx, content) -> {
            Object sanitized = contentSanitizer.apply((RequestContext)ctx, content);
            if (sanitized == null) {
                return "<sanitized>";
            }
            return sanitized.toString();
        })).includeContext(false).build().formatRequest(this);
    }
}

