/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.metric;

import java.util.ArrayList;
import java.util.List;
import karate.com.linecorp.armeria.common.metric.CloseableMeterBinder;
import karate.com.linecorp.armeria.internal.common.util.ReentrantShortLock;

abstract class AbstractCloseableMeterBinder
implements CloseableMeterBinder {
    private final List<Runnable> closingTasks = new ArrayList<Runnable>();
    private final ReentrantShortLock lock = new ReentrantShortLock();

    AbstractCloseableMeterBinder() {
    }

    protected final void addClosingTask(Runnable closingTask) {
        this.lock.lock();
        try {
            this.closingTasks.add(closingTask);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            for (Runnable task : this.closingTasks) {
                task.run();
            }
            this.closingTasks.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

