/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.metric;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import karate.com.linecorp.armeria.common.metric.AbstractCloseableMeterBinder;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.internal.common.util.CertificateUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.io.micrometer.core.instrument.Gauge;
import karate.io.micrometer.core.instrument.MeterRegistry;

public final class CertificateMetrics
extends AbstractCloseableMeterBinder {
    private final List<X509Certificate> certificates;
    private final MeterIdPrefix meterIdPrefix;

    CertificateMetrics(List<X509Certificate> certificates, MeterIdPrefix meterIdPrefix) {
        this.certificates = certificates;
        this.meterIdPrefix = meterIdPrefix;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        ArrayList<Gauge> meters = new ArrayList<Gauge>(this.certificates.size() * 2);
        for (X509Certificate certificate : this.certificates) {
            String commonName = MoreObjects.firstNonNull(CertificateUtil.getCommonName(certificate), "");
            Gauge validityMeter = Gauge.builder(this.meterIdPrefix.name("tls.certificate.validity"), certificate, x509Cert -> {
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    return 0.0;
                }
                return 1.0;
            }).description("1 if TLS certificate is in validity period, 0 if certificate is not in validity period").tags("common.name", commonName).tags(this.meterIdPrefix.tags()).register(registry);
            meters.add(validityMeter);
            Gauge validityDaysMeter = Gauge.builder(this.meterIdPrefix.name("tls.certificate.validity.days"), certificate, x509Cert -> {
                Instant notAfter = x509Cert.getNotAfter().toInstant();
                Duration diff = Duration.between(Instant.now(), notAfter);
                return diff.toDays();
            }).description("Duration in days before TLS certificate expires, which becomes -1 if certificate is expired").tags("common.name", commonName).tags(this.meterIdPrefix.tags()).register(registry);
            meters.add(validityDaysMeter);
        }
        this.addClosingTask(() -> {
            for (Gauge meter : meters) {
                registry.remove(meter);
            }
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("certificates", this.certificates).add("meterIdPrefix", this.meterIdPrefix).toString();
    }
}

