/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.Comparator;
import java.util.Objects;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.io.micrometer.core.instrument.Clock;
import karate.io.micrometer.core.instrument.Meter;
import karate.io.micrometer.core.instrument.Tag;
import karate.io.micrometer.core.instrument.config.MeterFilter;
import karate.io.micrometer.core.instrument.config.MeterFilterReply;
import karate.io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import karate.io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import karate.io.micrometer.core.instrument.util.HierarchicalNameMapper;

public final class DropwizardMeterRegistries {
    static final HierarchicalNameMapper DEFAULT_NAME_MAPPER = (id, convention) -> {
        String name = id.getConventionName(convention);
        if (!id.getTagsAsIterable().iterator().hasNext()) {
            return name;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        id.getConventionTags(convention).stream().sorted(Comparator.comparing(Tag::getKey)).forEach(tag -> {
            buf.append('.').append(tag.getKey());
            buf.append(':').append(tag.getValue());
        });
        return buf.toString();
    };
    static final DropwizardConfig DEFAULT_DROPWIZARD_CONFIG = new DropwizardConfig(){

        @Override
        public String prefix() {
            return "dropwizard";
        }

        @Override
        @Nullable
        public String get(String k) {
            return null;
        }
    };

    public static DropwizardMeterRegistry newRegistry() {
        return DropwizardMeterRegistries.newRegistry(new MetricRegistry(), DEFAULT_NAME_MAPPER);
    }

    public static DropwizardMeterRegistry newRegistry(MetricRegistry registry) {
        return DropwizardMeterRegistries.newRegistry(registry, DEFAULT_NAME_MAPPER);
    }

    public static DropwizardMeterRegistry newRegistry(HierarchicalNameMapper nameMapper) {
        return DropwizardMeterRegistries.newRegistry(new MetricRegistry(), nameMapper, Clock.SYSTEM);
    }

    public static DropwizardMeterRegistry newRegistry(MetricRegistry registry, HierarchicalNameMapper nameMapper) {
        return DropwizardMeterRegistries.newRegistry(registry, nameMapper, Clock.SYSTEM);
    }

    public static DropwizardMeterRegistry newRegistry(HierarchicalNameMapper nameMapper, Clock clock) {
        return DropwizardMeterRegistries.newRegistry(new MetricRegistry(), nameMapper, clock);
    }

    public static DropwizardMeterRegistry newRegistry(MetricRegistry registry, HierarchicalNameMapper nameMapper, Clock clock) {
        DropwizardMeterRegistry meterRegistry = new DropwizardMeterRegistry(DEFAULT_DROPWIZARD_CONFIG, Objects.requireNonNull(registry, "registry"), Objects.requireNonNull(nameMapper, "nameMapper"), Objects.requireNonNull(clock, "clock")){

            @Override
            protected Double nullGaugeValue() {
                return 0.0;
            }
        };
        return DropwizardMeterRegistries.configureRegistry(meterRegistry);
    }

    public static <T extends DropwizardMeterRegistry> T configureRegistry(T meterRegistry) {
        Objects.requireNonNull(meterRegistry, "meterRegistry");
        meterRegistry.config().meterFilter(new MeterFilter(){

            @Override
            public MeterFilterReply accept(Meter.Id id) {
                if (id.getName().endsWith(".percentile") && id.getTag("phi") != null) {
                    return MeterFilterReply.DENY;
                }
                if (id.getName().endsWith(".histogram") && id.getTag("le") != null) {
                    return MeterFilterReply.DENY;
                }
                return MeterFilterReply.NEUTRAL;
            }
        });
        return meterRegistry;
    }

    private DropwizardMeterRegistries() {
    }
}

