/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.metric;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import karate.com.linecorp.armeria.common.metric.AbstractCloseableMeterBinder;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.internal.common.metric.MicrometerUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterators;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.channel.EventLoopGroup;
import karate.io.netty.channel.SingleThreadEventLoop;
import karate.io.netty.util.concurrent.EventExecutor;

public final class EventLoopMetrics
extends AbstractCloseableMeterBinder {
    private final EventLoopGroup eventLoopGroup;
    private final MeterIdPrefix idPrefix;

    EventLoopMetrics(EventLoopGroup eventLoopGroup, MeterIdPrefix idPrefix) {
        this.eventLoopGroup = Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        this.idPrefix = idPrefix;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Self metrics = MicrometerUtil.register(registry, this.idPrefix, Self.class, Self::new);
        metrics.add(this.eventLoopGroup);
        this.addClosingTask(() -> metrics.remove(this.eventLoopGroup));
    }

    static final class Self {
        private final Set<EventLoopGroup> registry = ConcurrentHashMap.newKeySet(2);

        Self(MeterRegistry parent, MeterIdPrefix idPrefix) {
            String numWorkers = idPrefix.name("event.loop.workers");
            parent.gauge(numWorkers, idPrefix.tags(), this, Self::numWorkers);
            String pendingTasks = idPrefix.name("event.loop.pending.tasks");
            parent.gauge(pendingTasks, idPrefix.tags(), this, Self::pendingTasks);
        }

        void add(EventLoopGroup eventLoopGroup) {
            this.registry.add(eventLoopGroup);
        }

        void remove(EventLoopGroup eventLoopGroup) {
            this.registry.remove(eventLoopGroup);
        }

        double numWorkers() {
            int result = 0;
            for (EventLoopGroup group : this.registry) {
                if (group.isShutdown()) {
                    this.registry.remove(group);
                    continue;
                }
                result += Iterators.size(group.iterator());
            }
            return result;
        }

        double pendingTasks() {
            int result = 0;
            for (EventLoopGroup group : this.registry) {
                if (group.isShutdown()) {
                    this.remove(group);
                    continue;
                }
                for (EventExecutor eventLoop : group) {
                    if (!(eventLoop instanceof SingleThreadEventLoop)) continue;
                    result += ((SingleThreadEventLoop)eventLoop).pendingTasks();
                }
            }
            return result;
        }
    }
}

