/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.metric;

import java.io.File;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.metric.CertificateMetrics;
import karate.com.linecorp.armeria.common.metric.CloseableMeterBinder;
import karate.com.linecorp.armeria.common.metric.EventLoopMetrics;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.internal.common.util.CertificateUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.netty.channel.EventLoopGroup;

public final class MoreMeterBinders {
    @UnstableApi
    public static CloseableMeterBinder eventLoopMetrics(EventLoopGroup eventLoopGroup, String name) {
        Objects.requireNonNull(name, "name");
        return MoreMeterBinders.eventLoopMetrics(eventLoopGroup, new MeterIdPrefix("armeria.netty." + name));
    }

    @UnstableApi
    public static CloseableMeterBinder eventLoopMetrics(EventLoopGroup eventLoopGroup, MeterIdPrefix meterIdPrefix) {
        return new EventLoopMetrics(eventLoopGroup, meterIdPrefix);
    }

    @UnstableApi
    public static CloseableMeterBinder certificateMetrics(X509Certificate certificate, MeterIdPrefix meterIdPrefix) {
        Objects.requireNonNull(certificate, "certificate");
        return MoreMeterBinders.certificateMetrics(ImmutableList.of(certificate), meterIdPrefix);
    }

    @UnstableApi
    public static CloseableMeterBinder certificateMetrics(Iterable<? extends X509Certificate> certificates, MeterIdPrefix meterIdPrefix) {
        Objects.requireNonNull(certificates, "certificates");
        Objects.requireNonNull(meterIdPrefix, "meterIdPrefix");
        return new CertificateMetrics(ImmutableList.copyOf(certificates), meterIdPrefix);
    }

    @UnstableApi
    public static CloseableMeterBinder certificateMetrics(File keyCertChainFile, MeterIdPrefix meterIdPrefix) throws CertificateException {
        Objects.requireNonNull(keyCertChainFile, "keyCertChainFile");
        return MoreMeterBinders.certificateMetrics(CertificateUtil.toX509Certificates(keyCertChainFile), meterIdPrefix);
    }

    @UnstableApi
    public static CloseableMeterBinder certificateMetrics(InputStream keyCertChainFile, MeterIdPrefix meterIdPrefix) throws CertificateException {
        Objects.requireNonNull(keyCertChainFile, "keyCertChainFile");
        return MoreMeterBinders.certificateMetrics(CertificateUtil.toX509Certificates(keyCertChainFile), meterIdPrefix);
    }

    private MoreMeterBinders() {
    }
}

