/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.metric;

import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import karate.io.micrometer.core.instrument.DistributionSummary;
import karate.io.micrometer.core.instrument.Measurement;
import karate.io.micrometer.core.instrument.Meter;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.micrometer.core.instrument.Tag;
import karate.io.micrometer.core.instrument.Timer;
import karate.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;

public final class MoreMeters {
    private static volatile DistributionStatisticConfig defaultDistStatCfg = Flags.distributionStatisticConfig();

    public static void setDistributionStatisticConfig(DistributionStatisticConfig config) {
        Objects.requireNonNull(config, "config");
        defaultDistStatCfg = config;
    }

    public static DistributionStatisticConfig distributionStatisticConfig() {
        return defaultDistStatCfg;
    }

    public static DistributionSummary newDistributionSummary(MeterRegistry registry, String name, Iterable<Tag> tags) {
        return MoreMeters.newDistributionSummary(registry, name, tags, defaultDistStatCfg);
    }

    public static DistributionSummary newDistributionSummary(MeterRegistry registry, String name, Iterable<Tag> tags, DistributionStatisticConfig distStatsConfig) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(tags, "tags");
        Objects.requireNonNull(distStatsConfig, "distStatsConfig");
        return DistributionSummary.builder(name).tags(tags).publishPercentiles(distStatsConfig.getPercentiles()).publishPercentileHistogram(distStatsConfig.isPercentileHistogram()).percentilePrecision(distStatsConfig.getPercentilePrecision()).distributionStatisticBufferLength(distStatsConfig.getBufferLength()).distributionStatisticExpiry(distStatsConfig.getExpiry()).maximumExpectedValue(distStatsConfig.getMaximumExpectedValueAsDouble()).minimumExpectedValue(distStatsConfig.getMinimumExpectedValueAsDouble()).serviceLevelObjectives(distStatsConfig.getServiceLevelObjectiveBoundaries()).register(registry);
    }

    public static Timer newTimer(MeterRegistry registry, String name, Iterable<Tag> tags) {
        return MoreMeters.newTimer(registry, name, tags, defaultDistStatCfg);
    }

    public static Timer newTimer(MeterRegistry registry, String name, Iterable<Tag> tags, DistributionStatisticConfig distStatsConfig) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(tags, "tags");
        Objects.requireNonNull(distStatsConfig, "distStatsConfig");
        Double maxExpectedValueNanos = distStatsConfig.getMaximumExpectedValueAsDouble();
        Double minExpectedValueNanos = distStatsConfig.getMinimumExpectedValueAsDouble();
        Duration maxExpectedValue = maxExpectedValueNanos != null ? Duration.ofNanos(maxExpectedValueNanos.longValue()) : null;
        Duration minExpectedValue = minExpectedValueNanos != null ? Duration.ofNanos(minExpectedValueNanos.longValue()) : null;
        double[] sloBoundariesNanos = distStatsConfig.getServiceLevelObjectiveBoundaries();
        Duration[] sloBoundaries = sloBoundariesNanos != null ? (Duration[])Arrays.stream(sloBoundariesNanos).mapToObj(slo -> Duration.ofNanos((long)slo)).toArray(Duration[]::new) : null;
        return ((Timer.Builder)Timer.builder(name).tags((Iterable)tags)).maximumExpectedValue(maxExpectedValue).minimumExpectedValue(minExpectedValue).publishPercentiles(distStatsConfig.getPercentiles()).publishPercentileHistogram(distStatsConfig.isPercentileHistogram()).percentilePrecision(distStatsConfig.getPercentilePrecision()).distributionStatisticBufferLength(distStatsConfig.getBufferLength()).distributionStatisticExpiry(distStatsConfig.getExpiry()).serviceLevelObjectives(sloBoundaries).register(registry);
    }

    public static Map<String, Double> measureAll(MeterRegistry registry) {
        Objects.requireNonNull(registry, "registry");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        registry.forEachMeter(meter -> Streams.stream(meter.measure()).forEach(measurement -> {
            String fullName = MoreMeters.measurementName(meter.getId(), measurement);
            double value = measurement.getValue();
            builder.put(fullName, value);
        }));
        return builder.build();
    }

    private static String measurementName(Meter.Id id, Measurement measurement) {
        StringBuilder buf = new StringBuilder();
        buf.append(id.getName());
        buf.append('#');
        buf.append(measurement.getStatistic().getTagValueRepresentation());
        Iterator<Tag> tagsIterator = id.getTags().iterator();
        if (tagsIterator.hasNext()) {
            buf.append('{');
            tagsIterator.forEachRemaining(tag -> buf.append(tag.getKey()).append('=').append(tag.getValue()).append(','));
            buf.setCharAt(buf.length() - 1, '}');
        }
        return buf.toString();
    }

    private MoreMeters() {
    }
}

