/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.multipart;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.multipart.AggregatedBodyPart;
import karate.com.linecorp.armeria.common.multipart.DefaultAggregatedMultipart;
import karate.com.linecorp.armeria.common.multipart.DefaultMultipart;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;

public interface AggregatedMultipart {
    public static AggregatedMultipart of(AggregatedBodyPart ... bodyParts) {
        return AggregatedMultipart.of(DefaultMultipart.randomBoundary(), bodyParts);
    }

    public static AggregatedMultipart of(Iterable<? extends AggregatedBodyPart> bodyParts) {
        Objects.requireNonNull(bodyParts, "bodyParts");
        return AggregatedMultipart.of(DefaultMultipart.randomBoundary(), bodyParts);
    }

    public static AggregatedMultipart of(String boundary, AggregatedBodyPart ... bodyParts) {
        return AggregatedMultipart.of(boundary, ImmutableList.copyOf(Objects.requireNonNull(bodyParts, "bodyParts")));
    }

    public static AggregatedMultipart of(String boundary, Iterable<? extends AggregatedBodyPart> bodyParts) {
        Objects.requireNonNull(boundary, "boundary");
        Objects.requireNonNull(bodyParts, "bodyParts");
        return new DefaultAggregatedMultipart(boundary, ImmutableList.copyOf(bodyParts));
    }

    public String boundary();

    public List<AggregatedBodyPart> bodyParts();

    @Nullable
    default public AggregatedBodyPart field(String name) {
        Objects.requireNonNull(name, "name");
        return this.bodyParts().stream().filter(part -> name.equals(part.name())).findFirst().orElse(null);
    }

    default public List<AggregatedBodyPart> fields(String name) {
        Objects.requireNonNull(name, "name");
        return this.bodyParts().stream().filter(part -> name.equals(part.name())).collect(ImmutableList.toImmutableList());
    }

    default public Set<String> names() {
        return this.bodyParts().stream().map(AggregatedBodyPart::name).collect(ImmutableSet.toImmutableSet());
    }
}

