/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.multipart;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.multipart.AggregatedMultipart;
import karate.com.linecorp.armeria.common.multipart.BodyPart;
import karate.com.linecorp.armeria.common.multipart.DefaultMultipart;
import karate.com.linecorp.armeria.common.multipart.MultipartDecoder;
import karate.com.linecorp.armeria.common.multipart.Multiparts;
import karate.com.linecorp.armeria.common.stream.ByteStreamMessage;
import karate.com.linecorp.armeria.common.stream.StreamMessage;
import karate.com.linecorp.armeria.common.stream.SubscriptionOption;
import karate.com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import karate.io.netty.buffer.ByteBufAllocator;
import karate.io.netty.util.concurrent.EventExecutor;
import karate.org.reactivestreams.Publisher;

public interface Multipart {
    public static Multipart of(BodyPart ... parts) {
        return Multipart.of(DefaultMultipart.randomBoundary(), parts);
    }

    public static Multipart of(Iterable<? extends BodyPart> parts) {
        return Multipart.of(DefaultMultipart.randomBoundary(), parts);
    }

    public static Multipart of(String boundary, BodyPart ... parts) {
        Objects.requireNonNull(parts, "parts");
        return Multipart.of(boundary, ImmutableList.copyOf(parts));
    }

    public static Multipart of(String boundary, Iterable<? extends BodyPart> parts) {
        Objects.requireNonNull(boundary, "boundary");
        Objects.requireNonNull(parts, "parts");
        BodyPart[] bodyParts = Iterables.toArray(parts, BodyPart.class);
        return new DefaultMultipart(boundary, StreamMessage.of(bodyParts));
    }

    public static Multipart of(Publisher<? extends BodyPart> parts) {
        return Multipart.of(DefaultMultipart.randomBoundary(), parts);
    }

    public static Multipart of(String boundary, Publisher<? extends BodyPart> parts) {
        Objects.requireNonNull(parts, "parts");
        return new DefaultMultipart(boundary, StreamMessage.of(parts));
    }

    public static Multipart from(HttpRequest request) {
        Objects.requireNonNull(request, "request");
        RequestHeaders headers = request.headers();
        @Nullable MediaType mediaType = headers.contentType();
        Preconditions.checkState(mediaType != null, "Content-Type header is missing");
        String boundary = Multiparts.getBoundary(mediaType);
        StreamMessage<HttpObject> cast = request.filter(HttpData.class::isInstance);
        return Multipart.from(boundary, cast);
    }

    public static Multipart from(String boundary, Publisher<? extends HttpData> contents) {
        return Multipart.from(boundary, contents, ByteBufAllocator.DEFAULT);
    }

    public static Multipart from(String boundary, Publisher<? extends HttpData> contents, ByteBufAllocator alloc) {
        Objects.requireNonNull(boundary, "boundary");
        Objects.requireNonNull(contents, "contents");
        Objects.requireNonNull(alloc, "alloc");
        MultipartDecoder decoder = new MultipartDecoder(StreamMessage.of(contents), boundary, alloc);
        return Multipart.of(boundary, decoder);
    }

    public HttpRequest toHttpRequest(String var1);

    public HttpRequest toHttpRequest(RequestHeaders var1);

    public HttpResponse toHttpResponse(HttpStatus var1);

    public HttpResponse toHttpResponse(ResponseHeaders var1);

    @CheckReturnValue
    public ByteStreamMessage toStreamMessage();

    public String boundary();

    @CheckReturnValue
    public StreamMessage<BodyPart> bodyParts();

    public CompletableFuture<AggregatedMultipart> aggregate();

    public CompletableFuture<AggregatedMultipart> aggregate(EventExecutor var1);

    public CompletableFuture<AggregatedMultipart> aggregateWithPooledObjects(ByteBufAllocator var1);

    public CompletableFuture<AggregatedMultipart> aggregateWithPooledObjects(EventExecutor var1, ByteBufAllocator var2);

    @UnstableApi
    default public <T> CompletableFuture<List<T>> collect(Function<? super BodyPart, CompletableFuture<? extends T>> function) {
        return this.collect(function, InternalStreamMessageUtil.EMPTY_OPTIONS);
    }

    @UnstableApi
    default public <T> CompletableFuture<List<T>> collect(Function<? super BodyPart, CompletableFuture<? extends T>> function, SubscriptionOption ... options) {
        return this.bodyParts().mapAsync(function).collect(options);
    }
}

