/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.outlier;

import java.time.Duration;
import java.util.Objects;
import karate.com.linecorp.armeria.common.outlier.DefaultOutlierDetector;
import karate.com.linecorp.armeria.common.outlier.OutlierDetection;
import karate.com.linecorp.armeria.common.outlier.OutlierDetector;
import karate.com.linecorp.armeria.common.outlier.OutlierRule;
import karate.com.linecorp.armeria.common.util.Ticker;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;

final class DefaultOutlierDetection
implements OutlierDetection {
    private final OutlierRule rule;
    private final Ticker ticker;
    private final Duration counterSlidingWindow;
    private final Duration counterUpdateInterval;
    private final double failureRateThreshold;
    private final long minimumRequestThreshold;

    DefaultOutlierDetection(OutlierRule rule, Ticker ticker, Duration counterSlidingWindow, Duration counterUpdateInterval, double failureRateThreshold, long minimumRequestThreshold) {
        this.rule = rule;
        this.ticker = ticker;
        this.counterSlidingWindow = counterSlidingWindow;
        this.counterUpdateInterval = counterUpdateInterval;
        this.failureRateThreshold = failureRateThreshold;
        this.minimumRequestThreshold = minimumRequestThreshold;
    }

    @Override
    public OutlierRule rule() {
        return this.rule;
    }

    @Override
    public OutlierDetector newDetector() {
        return new DefaultOutlierDetector(this.ticker, this.counterSlidingWindow, this.counterUpdateInterval, this.failureRateThreshold, this.minimumRequestThreshold);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultOutlierDetection)) {
            return false;
        }
        DefaultOutlierDetection that = (DefaultOutlierDetection)o;
        return Double.compare(this.failureRateThreshold, that.failureRateThreshold) == 0 && this.minimumRequestThreshold == that.minimumRequestThreshold && this.counterSlidingWindow.equals(that.counterSlidingWindow) && this.counterUpdateInterval.equals(that.counterUpdateInterval) && this.rule.equals(that.rule) && this.ticker.equals(that.ticker);
    }

    public int hashCode() {
        return Objects.hash(this.rule, this.ticker, this.counterSlidingWindow, this.counterUpdateInterval, this.failureRateThreshold, this.minimumRequestThreshold);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rule", this.rule).add("ticker", this.ticker).add("counterSlidingWindow", this.counterSlidingWindow).add("counterUpdateInterval", this.counterUpdateInterval).add("failureRateThreshold", this.failureRateThreshold).add("minimumRequestThreshold", this.minimumRequestThreshold).toString();
    }
}

