/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.outlier;

import java.time.Duration;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.outlier.OutlierDetector;
import karate.com.linecorp.armeria.common.util.EventCount;
import karate.com.linecorp.armeria.common.util.EventCounter;
import karate.com.linecorp.armeria.common.util.Ticker;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;

final class DefaultOutlierDetector
implements OutlierDetector {
    private final EventCounter counter;
    private final double failureRateThreshold;
    private final long minimumRequestThreshold;
    private volatile boolean isOutlier;

    DefaultOutlierDetector(Ticker ticker, Duration slidingWindow, Duration updateInterval, double failureRateThreshold, long minimumRequestThreshold) {
        this.counter = EventCounter.ofSlidingWindow(ticker, slidingWindow, updateInterval);
        this.failureRateThreshold = failureRateThreshold;
        this.minimumRequestThreshold = minimumRequestThreshold;
    }

    @Override
    public void onSuccess() {
        if (this.isOutlier) {
            return;
        }
        this.checkIfExceedingFailureThreshold(this.counter.onSuccess());
    }

    @Override
    public void onFailure() {
        if (this.isOutlier) {
            return;
        }
        this.checkIfExceedingFailureThreshold(this.counter.onFailure());
    }

    @Override
    public boolean isOutlier() {
        return this.isOutlier;
    }

    private void checkIfExceedingFailureThreshold(@Nullable EventCount count) {
        boolean exceeds;
        if (count == null) {
            return;
        }
        boolean bl = exceeds = 0L < count.total() && this.minimumRequestThreshold <= count.total() && this.failureRateThreshold < count.failureRate();
        if (exceeds) {
            this.isOutlier = true;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("counter", this.counter).add("failureRateThreshold", this.failureRateThreshold).add("minimumRequestThreshold", this.minimumRequestThreshold).add("isOutlier", this.isOutlier).toString();
    }
}

