/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.stream;

import java.io.InputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.stream.DefaultByteStreamMessage;
import karate.com.linecorp.armeria.common.stream.StreamMessage;
import karate.com.linecorp.armeria.common.stream.SubscriptionOption;
import karate.io.netty.util.concurrent.EventExecutor;
import karate.org.reactivestreams.Publisher;

@UnstableApi
public interface ByteStreamMessage
extends StreamMessage<HttpData> {
    public static ByteStreamMessage of(Publisher<? extends HttpData> publisher) {
        Objects.requireNonNull(publisher, "publisher");
        if (publisher instanceof ByteStreamMessage) {
            return (ByteStreamMessage)publisher;
        }
        return new DefaultByteStreamMessage(StreamMessage.of(publisher));
    }

    default public InputStream toInputStream() {
        return StreamMessage.super.toInputStream(Function.identity());
    }

    default public CompletableFuture<Void> writeTo(Path destination, OpenOption ... options) {
        return StreamMessage.super.writeTo(Function.identity(), destination, options);
    }

    public ByteStreamMessage range(long var1, long var3);

    default public CompletableFuture<byte[]> collectBytes() {
        return this.collectBytes(this.defaultSubscriberExecutor());
    }

    default public CompletableFuture<byte[]> collectBytes(EventExecutor executor) {
        return this.collect(executor, new SubscriptionOption[0]).thenApply(data -> {
            int totalSize = 0;
            for (HttpData httpData : data) {
                totalSize += httpData.length();
            }
            byte[] bytes = new byte[totalSize];
            int position = 0;
            for (HttpData httpData : data) {
                int length = httpData.length();
                System.arraycopy(httpData.array(), 0, bytes, position, length);
                position += length;
            }
            return bytes;
        });
    }
}

