/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.stream;

import java.util.Objects;
import karate.com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import karate.org.reactivestreams.Subscriber;
import karate.org.reactivestreams.Subscription;

public final class NoopSubscriber<T>
implements Subscriber<T> {
    private static final NoopSubscriber<?> INSTANCE = new NoopSubscriber();

    public static <T> NoopSubscriber<T> get() {
        return INSTANCE;
    }

    @Override
    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T item) {
        Objects.requireNonNull(item, "item");
        StreamMessageUtil.closeOrAbort(item);
    }

    @Override
    public void onError(Throwable t) {
    }

    @Override
    public void onComplete() {
    }
}

