/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.stream;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.stream.SubscriptionOption;
import karate.com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import karate.com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.org.reactivestreams.Subscriber;
import karate.org.reactivestreams.Subscription;

final class StreamMessageCollector<T>
implements Subscriber<T> {
    private final CompletableFuture<List<T>> future = new CompletableFuture();
    private final boolean withPooledObjects;
    @Nullable
    private ImmutableList.Builder<T> elementsBuilder = ImmutableList.builder();

    StreamMessageCollector(SubscriptionOption ... options) {
        this.withPooledObjects = InternalStreamMessageUtil.containsWithPooledObjects(options);
    }

    CompletableFuture<List<T>> collect() {
        return this.future;
    }

    @Override
    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T o) {
        Objects.requireNonNull(o, "o");
        assert (this.elementsBuilder != null);
        this.elementsBuilder.add((Object)StreamMessageUtil.touchOrCopyAndClose(o, this.withPooledObjects));
    }

    @Override
    public void onComplete() {
        if (this.future.isDone()) {
            return;
        }
        assert (this.elementsBuilder != null);
        this.future.complete((List<ImmutableCollection>)((Object)this.elementsBuilder.build()));
        this.elementsBuilder = null;
    }

    @Override
    public void onError(Throwable t) {
        if (this.future.isDone()) {
            return;
        }
        assert (this.elementsBuilder != null);
        ImmutableCollection elements = this.elementsBuilder.build();
        for (Object element : elements) {
            StreamMessageUtil.closeOrAbort(element, t);
        }
        this.future.completeExceptionally(t);
        this.elementsBuilder = null;
    }
}

