/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.stream;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.common.stream.ClosedStreamException;
import karate.com.linecorp.armeria.common.stream.StreamMessage;

public interface StreamWriter<T>
extends StreamMessage<T> {
    @Override
    public boolean isOpen();

    default public void write(T o) {
        if (!this.tryWrite(o)) {
            throw ClosedStreamException.get();
        }
    }

    default public void write(Supplier<? extends T> o) {
        if (!this.tryWrite(o)) {
            throw ClosedStreamException.get();
        }
    }

    @CheckReturnValue
    public boolean tryWrite(T var1);

    @CheckReturnValue
    default public boolean tryWrite(Supplier<? extends T> o) {
        Objects.requireNonNull(o, "o");
        T obj = Objects.requireNonNull(o.get(), "o.get() returned null");
        return this.tryWrite(obj);
    }

    public CompletableFuture<Void> whenConsumed();

    public void close();

    public void close(Throwable var1);
}

