/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import karate.com.linecorp.armeria.common.util.AbstractOption;
import karate.com.linecorp.armeria.common.util.AbstractOptionValue;
import karate.com.linecorp.armeria.internal.shaded.fastutil.objects.Reference2ReferenceOpenHashMap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterators;

public abstract class AbstractOptions<T extends AbstractOption<T, U, Object>, U extends AbstractOptionValue<U, T, Object>>
implements Iterable<U> {
    private final Reference2ReferenceOpenHashMap<T, U> valueMap;

    protected AbstractOptions(Iterable<? extends AbstractOptionValue<?, ?, ?>> values) {
        Objects.requireNonNull(values, "values");
        this.valueMap = this.init(values);
    }

    protected AbstractOptions(AbstractOptions<T, U> baseOptions, Iterable<? extends AbstractOptionValue<?, ?, ?>> additionalValues) {
        Objects.requireNonNull(baseOptions, "baseOptions");
        Objects.requireNonNull(additionalValues, "additionalValues");
        this.valueMap = baseOptions.valueMap.isEmpty() ? this.init(additionalValues) : this.init(baseOptions, additionalValues);
    }

    private Reference2ReferenceOpenHashMap<T, U> init(Iterable<? extends AbstractOptionValue<?, ?, ?>> additionalValues) {
        if (additionalValues instanceof AbstractOptions) {
            Object clone = ((AbstractOptions)additionalValues).valueMap.clone();
            return clone;
        }
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        Iterator<AbstractOptionValue<?, ?, ?>> iterator = additionalValues.iterator();
        while (iterator.hasNext()) {
            AbstractOptionValue<?, ?, ?> value;
            AbstractOptionValue<?, ?, ?> newValue = value = iterator.next();
            map.put(newValue.option(), newValue);
        }
        return map;
    }

    private Reference2ReferenceOpenHashMap<T, U> init(AbstractOptions<T, U> baseOptions, Iterable<? extends AbstractOptionValue<?, ?, ?>> additionalValues) {
        if (additionalValues instanceof AbstractOptions) {
            Reference2ReferenceOpenHashMap<T, U> additionalValueMap = ((AbstractOptions)((Object)additionalValues)).valueMap;
            additionalValues = additionalValueMap.values();
        }
        Object map = baseOptions.valueMap.clone();
        for (AbstractOptionValue<?, ?, ?> value : additionalValues) {
            AbstractOptionValue<?, ?, ?> newValue = value;
            Object option = newValue.option();
            AbstractOptionValue<?, ?, ?> oldValue = ((Reference2ReferenceOpenHashMap)map).putIfAbsent(option, newValue);
            if (oldValue == null) continue;
            ((Reference2ReferenceOpenHashMap)map).put(option, ((AbstractOption)option).merge(oldValue, newValue));
        }
        return map;
    }

    public final <V> V get(AbstractOption<?, ?, V> option) {
        Objects.requireNonNull(option, "option");
        AbstractOptionValue optionValue = (AbstractOptionValue)this.valueMap.get(option);
        if (optionValue == null) {
            return option.defaultValue();
        }
        Object cast = optionValue.value();
        return cast;
    }

    @Override
    public final Iterator<U> iterator() {
        return Iterators.unmodifiableIterator(this.valueMap.values().iterator());
    }

    public final Map<T, U> asMap() {
        return Collections.unmodifiableMap(this.valueMap);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + Iterators.toString(this.valueMap.values().iterator());
    }
}

