/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.util;

import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import karate.com.linecorp.armeria.common.CommonPools;
import karate.com.linecorp.armeria.common.util.BlockingTaskExecutorBuilder;
import karate.com.linecorp.armeria.common.util.DefaultBlockingTaskExecutor;

public interface BlockingTaskExecutor
extends ScheduledExecutorService {
    public static BlockingTaskExecutor of() {
        return CommonPools.blockingTaskExecutor();
    }

    public static BlockingTaskExecutor of(ScheduledExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof BlockingTaskExecutor) {
            return (BlockingTaskExecutor)executor;
        }
        return new DefaultBlockingTaskExecutor(executor);
    }

    public static BlockingTaskExecutorBuilder builder() {
        return new BlockingTaskExecutorBuilder();
    }

    default public ScheduledExecutorService unwrap() {
        return this;
    }
}

