/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Objects;
import karate.com.linecorp.armeria.client.Endpoint;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.common.util.DomainSocketUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@UnstableApi
public final class DomainSocketAddress
extends InetSocketAddress {
    private static final long serialVersionUID = 41779966264274119L;
    private final String path;
    @Nullable
    private String authority;
    @Nullable
    private Endpoint endpoint;
    @Nullable
    private karate.io.netty.channel.unix.DomainSocketAddress nettyAddress;

    public static DomainSocketAddress of(Path path) {
        return DomainSocketAddress.of(Objects.requireNonNull(path, "path").toString());
    }

    public static DomainSocketAddress of(String path) {
        Objects.requireNonNull(path, "path");
        Preconditions.checkArgument(!path.isEmpty(), "path must not be empty.");
        return new DomainSocketAddress(path);
    }

    public static DomainSocketAddress of(karate.io.netty.channel.unix.DomainSocketAddress nettyAddr) {
        String path = Objects.requireNonNull(nettyAddr, "nettyAddr").path();
        Preconditions.checkArgument(!path.isEmpty(), "nettyAddr.path must not be empty.");
        return new DomainSocketAddress(path);
    }

    public static boolean isDomainSocketAddress(InetAddress addr) {
        Objects.requireNonNull(addr, "addr");
        return DomainSocketUtil.isDomainSocketAddress(addr);
    }

    private DomainSocketAddress(String path) {
        super(DomainSocketUtil.toInetAddress(Objects.requireNonNull(path, "path")), 1);
        this.path = path;
    }

    public String path() {
        return this.path;
    }

    public boolean isAbstract() {
        return this.path.charAt(0) == '\u0000';
    }

    public String authority() {
        String newAuthority;
        String authority = this.authority;
        if (authority != null) {
            return authority;
        }
        this.authority = newAuthority = DomainSocketUtil.toAuthority(this.path);
        return newAuthority;
    }

    public karate.io.netty.channel.unix.DomainSocketAddress asNettyAddress() {
        karate.io.netty.channel.unix.DomainSocketAddress newNettyAddress;
        karate.io.netty.channel.unix.DomainSocketAddress nettyAddress = this.nettyAddress;
        if (nettyAddress != null) {
            return nettyAddress;
        }
        this.nettyAddress = newNettyAddress = new karate.io.netty.channel.unix.DomainSocketAddress(this.path);
        return newNettyAddress;
    }

    public Endpoint asEndpoint() {
        Endpoint newEndpoint;
        Endpoint endpoint = this.endpoint;
        if (endpoint != null) {
            return endpoint;
        }
        this.endpoint = newEndpoint = Endpoint.of(this.authority());
        return newEndpoint;
    }

    @Override
    public String toString() {
        if (this.isAbstract()) {
            return this.path.replace('\u0000', '@');
        }
        return this.path;
    }
}

