/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.util;

import java.time.Duration;
import java.util.Objects;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.util.EventCount;
import karate.com.linecorp.armeria.common.util.SlidingWindowCounter;
import karate.com.linecorp.armeria.common.util.Ticker;

@UnstableApi
public interface EventCounter {
    public static EventCounter ofSlidingWindow(Ticker ticker, Duration slidingWindow, Duration updateInterval) {
        Objects.requireNonNull(ticker, "ticker");
        Objects.requireNonNull(slidingWindow, "slidingWindow");
        Objects.requireNonNull(updateInterval, "updateInterval");
        return new SlidingWindowCounter(ticker, slidingWindow, updateInterval);
    }

    public static EventCounter ofSlidingWindow(Duration slidingWindow, Duration updateInterval) {
        return EventCounter.ofSlidingWindow(Ticker.systemTicker(), slidingWindow, updateInterval);
    }

    public EventCount count();

    @Nullable
    public EventCount onSuccess();

    @Nullable
    public EventCount onFailure();
}

