/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.util;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import karate.com.linecorp.armeria.common.util.Exceptions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.netty.util.concurrent.Future;

public class UnmodifiableFuture<T>
extends EventLoopCheckingFuture<T> {
    private static final UnmodifiableFuture<?> NIL = new UnmodifiableFuture();
    private static final UnmodifiableFuture<Boolean> TRUE;
    private static final UnmodifiableFuture<Boolean> FALSE;
    private static final UnmodifiableFuture<List> IMMUTABLE_LIST;

    public static <U> UnmodifiableFuture<U> completedFuture(@Nullable U value) {
        if (value == null) {
            UnmodifiableFuture<?> cast = NIL;
            return cast;
        }
        if (value == Boolean.TRUE) {
            UnmodifiableFuture<Boolean> cast = TRUE;
            return cast;
        }
        if (value == Boolean.FALSE) {
            UnmodifiableFuture<Boolean> cast = FALSE;
            return cast;
        }
        if (value == ImmutableList.of()) {
            UnmodifiableFuture<List> cast = IMMUTABLE_LIST;
            return cast;
        }
        UnmodifiableFuture<U> future = new UnmodifiableFuture<U>();
        future.doComplete(value);
        return future;
    }

    public static <U> UnmodifiableFuture<U> exceptionallyCompletedFuture(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        UnmodifiableFuture future = new UnmodifiableFuture();
        future.doCompleteExceptionally(cause);
        return future;
    }

    public static <U> UnmodifiableFuture<U> wrap(CompletableFuture<U> future) {
        Objects.requireNonNull(future, "future");
        UnmodifiableFuture unmodifiable = new UnmodifiableFuture();
        future.handle((T result, U cause) -> {
            if (cause != null) {
                unmodifiable.doCompleteExceptionally(Exceptions.peel(cause));
            } else {
                unmodifiable.doComplete(result);
            }
            return null;
        });
        return unmodifiable;
    }

    @UnstableApi
    public static <U> UnmodifiableFuture<U> fromNetty(Future<U> future) {
        Objects.requireNonNull(future, "future");
        UnmodifiableFuture cf = new UnmodifiableFuture();
        if (future.isDone()) {
            UnmodifiableFuture.toCompletableFuture(future, cf);
        } else {
            future.addListener(future0 -> UnmodifiableFuture.toCompletableFuture(future0, cf));
        }
        return cf;
    }

    private static <U> void toCompletableFuture(Future<U> future, UnmodifiableFuture<U> cf) {
        if (future.isSuccess()) {
            cf.doComplete(future.getNow());
        } else {
            cf.doCompleteExceptionally(future.cause());
        }
    }

    protected UnmodifiableFuture() {
    }

    @Override
    public boolean complete(@Nullable T value) {
        throw new UnsupportedOperationException();
    }

    protected void doComplete(@Nullable T value) {
        super.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        throw new UnsupportedOperationException();
    }

    protected void doCompleteExceptionally(Throwable cause) {
        super.completeExceptionally(cause);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.isCancelled();
    }

    protected boolean doCancel() {
        return super.cancel(false);
    }

    @Override
    public void obtrudeValue(@Nullable T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void obtrudeException(Throwable ex) {
        throw new UnsupportedOperationException();
    }

    static {
        NIL.doComplete(null);
        TRUE = new UnmodifiableFuture();
        TRUE.doComplete(Boolean.TRUE);
        FALSE = new UnmodifiableFuture();
        FALSE.doComplete(Boolean.FALSE);
        IMMUTABLE_LIST = new UnmodifiableFuture();
        IMMUTABLE_LIST.doComplete(ImmutableList.of());
    }
}

