/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.websocket;

import java.nio.charset.StandardCharsets;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.websocket.WebSocketFrame;
import karate.com.linecorp.armeria.common.websocket.WebSocketFrameType;
import karate.com.linecorp.armeria.internal.common.ByteBufBytes;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.ByteBufUtil;

class ByteBufWebSocketFrame
extends ByteBufBytes
implements WebSocketFrame {
    private final WebSocketFrameType type;
    private final boolean finalFragment;
    @Nullable
    private String text;

    ByteBufWebSocketFrame(ByteBuf buf, WebSocketFrameType type, boolean finalFragment) {
        this(buf, true, type, finalFragment);
    }

    ByteBufWebSocketFrame(ByteBuf buf, boolean pooled, WebSocketFrameType type, boolean finalFragment) {
        super(buf, pooled);
        this.type = type;
        this.finalFragment = finalFragment;
    }

    @Override
    public WebSocketFrameType type() {
        return this.type;
    }

    @Override
    public boolean isFinalFragment() {
        return this.finalFragment;
    }

    @Override
    public String text() {
        if (this.text != null) {
            return this.text;
        }
        this.text = this.toString(StandardCharsets.UTF_8);
        return this.text;
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.type.hashCode()) * 31 + Boolean.hashCode(this.finalFragment);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WebSocketFrame)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        WebSocketFrame that = (WebSocketFrame)obj;
        if (this.length() != that.length()) {
            return false;
        }
        return this.type == that.type() && this.finalFragment == that.isFinalFragment() && ByteBufUtil.equals(this.buf(), that.byteBuf());
    }

    @Override
    public String toString() {
        return this.toString(super.toString());
    }

    private String toString(String bytes) {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).omitNullValues();
        toStringHelper.add("type", (Object)this.type()).add("finalFragment", this.finalFragment).add("bytes", bytes);
        this.addToString(toStringHelper);
        return toStringHelper.toString();
    }

    void addToString(MoreObjects.ToStringHelper toStringHelper) {
    }
}

