/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.websocket;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import karate.com.linecorp.armeria.common.Bytes;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.websocket.ByteArrayWebSocketFrame;
import karate.com.linecorp.armeria.common.websocket.ByteBufWebSocketFrame;
import karate.com.linecorp.armeria.common.websocket.CloseByteBufWebSocketFrame;
import karate.com.linecorp.armeria.common.websocket.CloseWebSocketFrame;
import karate.com.linecorp.armeria.common.websocket.WebSocketCloseStatus;
import karate.com.linecorp.armeria.common.websocket.WebSocketFrameType;
import karate.io.netty.buffer.ByteBuf;

@UnstableApi
public interface WebSocketFrame
extends Bytes {
    public static WebSocketFrame ofText(String text) {
        return WebSocketFrame.ofText(text, true);
    }

    public static WebSocketFrame ofText(String text, boolean finalFragment) {
        Objects.requireNonNull(text, "text");
        return new ByteArrayWebSocketFrame(text.getBytes(StandardCharsets.UTF_8), WebSocketFrameType.TEXT, finalFragment, text);
    }

    public static WebSocketFrame ofText(byte[] text) {
        Objects.requireNonNull(text, "text");
        return WebSocketFrame.ofText(text, true);
    }

    public static WebSocketFrame ofText(byte[] text, boolean finalFragment) {
        Objects.requireNonNull(text, "text");
        return new ByteArrayWebSocketFrame(text, WebSocketFrameType.TEXT, finalFragment);
    }

    public static WebSocketFrame ofBinary(byte[] data) {
        Objects.requireNonNull(data, "data");
        return WebSocketFrame.ofBinary(data, true);
    }

    public static WebSocketFrame ofBinary(byte[] data, boolean finalFragment) {
        Objects.requireNonNull(data, "data");
        return new ByteArrayWebSocketFrame(data, WebSocketFrameType.BINARY, finalFragment);
    }

    public static CloseWebSocketFrame ofClose(WebSocketCloseStatus status) {
        Objects.requireNonNull(status, "status");
        return WebSocketFrame.ofClose(status, status.reasonPhrase());
    }

    public static CloseWebSocketFrame ofClose(WebSocketCloseStatus status, String reason) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(reason, "reason");
        return new CloseByteBufWebSocketFrame(status, reason);
    }

    public static CloseWebSocketFrame ofClose(byte[] data) {
        Objects.requireNonNull(data, "data");
        return new CloseByteBufWebSocketFrame(data);
    }

    public static WebSocketFrame ofPing() {
        return ByteArrayWebSocketFrame.EMPTY_PING;
    }

    public static WebSocketFrame ofPing(byte[] data) {
        Objects.requireNonNull(data, "data");
        if (data.length == 0) {
            return ByteArrayWebSocketFrame.EMPTY_PING;
        }
        return new ByteArrayWebSocketFrame(data, WebSocketFrameType.PING);
    }

    public static WebSocketFrame ofPong() {
        return ByteArrayWebSocketFrame.EMPTY_PONG;
    }

    public static WebSocketFrame ofPong(byte[] data) {
        Objects.requireNonNull(data, "data");
        if (data.length == 0) {
            return ByteArrayWebSocketFrame.EMPTY_PONG;
        }
        return new ByteArrayWebSocketFrame(data, WebSocketFrameType.PONG);
    }

    public static WebSocketFrame ofContinuation(byte[] data) {
        return WebSocketFrame.ofContinuation(data, true);
    }

    public static WebSocketFrame ofContinuation(byte[] data, boolean finalFragment) {
        Objects.requireNonNull(data, "data");
        return new ByteArrayWebSocketFrame(data, WebSocketFrameType.CONTINUATION, finalFragment);
    }

    public static WebSocketFrame ofContinuation(String text) {
        return WebSocketFrame.ofContinuation(text, true);
    }

    public static WebSocketFrame ofContinuation(String text, boolean finalFragment) {
        Objects.requireNonNull(text, "text");
        return new ByteArrayWebSocketFrame(text.getBytes(StandardCharsets.UTF_8), WebSocketFrameType.CONTINUATION, finalFragment, text);
    }

    public static WebSocketFrame ofPooledText(ByteBuf text) {
        Objects.requireNonNull(text, "text");
        return WebSocketFrame.ofPooledText(text, true);
    }

    public static WebSocketFrame ofPooledText(ByteBuf text, boolean finalFragment) {
        Objects.requireNonNull(text, "text");
        return new ByteBufWebSocketFrame(text, WebSocketFrameType.TEXT, finalFragment);
    }

    public static WebSocketFrame ofPooledBinary(ByteBuf data) {
        Objects.requireNonNull(data, "data");
        return WebSocketFrame.ofPooledBinary(data, true);
    }

    public static WebSocketFrame ofPooledBinary(ByteBuf data, boolean finalFragment) {
        Objects.requireNonNull(data, "data");
        return new ByteBufWebSocketFrame(data, WebSocketFrameType.BINARY, finalFragment);
    }

    public static CloseWebSocketFrame ofPooledClose(ByteBuf data) {
        Objects.requireNonNull(data, "data");
        return new CloseByteBufWebSocketFrame(data, true);
    }

    public static WebSocketFrame ofPooledPing(ByteBuf data) {
        Objects.requireNonNull(data, "data");
        if (data.readableBytes() == 0) {
            data.release();
            return ByteArrayWebSocketFrame.EMPTY_PING;
        }
        return new ByteBufWebSocketFrame(data, WebSocketFrameType.PING, true);
    }

    public static WebSocketFrame ofPooledPong(ByteBuf data) {
        Objects.requireNonNull(data, "data");
        if (data.readableBytes() == 0) {
            data.release();
            return ByteArrayWebSocketFrame.EMPTY_PONG;
        }
        return new ByteBufWebSocketFrame(data, WebSocketFrameType.PONG, true);
    }

    public static WebSocketFrame ofPooledContinuation(ByteBuf data) {
        return WebSocketFrame.ofPooledContinuation(data, true);
    }

    public static WebSocketFrame ofPooledContinuation(ByteBuf data, boolean finalFragment) {
        Objects.requireNonNull(data, "data");
        return new ByteBufWebSocketFrame(data, WebSocketFrameType.CONTINUATION, finalFragment);
    }

    public WebSocketFrameType type();

    public boolean isFinalFragment();

    public String text();
}

