/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.client;

import karate.com.linecorp.armeria.common.AggregatedHttpRequest;
import karate.com.linecorp.armeria.common.ByteBufAccessMode;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpRequestDuplicator;
import karate.com.linecorp.armeria.common.RequestHeaders;

public final class AggregatedHttpRequestDuplicator
implements HttpRequestDuplicator {
    private final AggregatedHttpRequest request;

    public AggregatedHttpRequestDuplicator(AggregatedHttpRequest request) {
        this.request = request;
    }

    @Override
    public RequestHeaders headers() {
        return this.request.headers();
    }

    @Override
    public HttpRequest duplicate() {
        return this.duplicate(this.request.headers());
    }

    @Override
    public HttpRequest duplicate(RequestHeaders newHeaders) {
        HttpData content = this.request.content();
        if (!content.isPooled()) {
            return HttpRequest.of(newHeaders, content, this.request.trailers());
        }
        content = HttpData.wrap(content.byteBuf(ByteBufAccessMode.RETAINED_DUPLICATE));
        return HttpRequest.of(newHeaders, content, this.request.trailers());
    }

    @Override
    public void close() {
        this.request.content().close();
    }

    @Override
    public void abort() {
        this.close();
    }

    @Override
    public void abort(Throwable cause) {
        this.close();
    }
}

