/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.client;

import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PendingExceptionUtil {
    private static final Logger logger = LoggerFactory.getLogger(PendingExceptionUtil.class);
    private static final AttributeKey<Throwable> PENDING_EXCEPTION = AttributeKey.valueOf(PendingExceptionUtil.class, "PENDING_EXCEPTION");

    @Nullable
    public static Throwable getPendingException(ChannelHandlerContext ctx) {
        return PendingExceptionUtil.getPendingException(ctx.channel());
    }

    @Nullable
    public static Throwable getPendingException(Channel channel) {
        if (channel.hasAttr(PENDING_EXCEPTION)) {
            return channel.attr(PENDING_EXCEPTION).get();
        }
        return null;
    }

    public static void setPendingException(ChannelHandlerContext ctx, Throwable cause) {
        PendingExceptionUtil.setPendingException(ctx.channel(), cause);
    }

    public static void setPendingException(Channel channel, Throwable cause) {
        Throwable previousCause = channel.attr(PENDING_EXCEPTION).setIfAbsent(cause);
        if (previousCause != null) {
            logger.warn("{} Unexpected suppressed exception:", (Object)channel, (Object)cause);
        }
    }

    private PendingExceptionUtil() {
    }
}

