/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import karate.com.linecorp.armeria.internal.shaded.guava.base.CharMatcher;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

public final class PublicSuffix {
    private static final CharMatcher DOTS_MATCHER = CharMatcher.anyOf(".\u3002\uff0e\uff61");
    private final TrieNode trie = new TrieNode();

    public static PublicSuffix get() {
        return PublicSuffixHolder.INSTANCE;
    }

    private PublicSuffix() {
        this.buildTrie();
    }

    private void buildTrie() {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("karate/com/linecorp/armeria/public_suffixes.txt");){
            Preconditions.checkState(in != null, "public_suffixes.txt not found.");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] labels = line.split("\\.");
                    TrieNode node = this.trie;
                    for (int i = labels.length - 1; i >= 0; --i) {
                        if ("*".equals(labels[i])) {
                            node.isWildcard = true;
                            break;
                        }
                        if (node.children == null) {
                            node.children = new HashMap<String, TrieNode>();
                        }
                        if (node.children.containsKey(labels[i])) {
                            node = node.children.get(labels[i]);
                            assert (node != null);
                            continue;
                        }
                        TrieNode newNode = new TrieNode();
                        if (labels[i].charAt(0) == '!') {
                            newNode.isException = true;
                            node.children.put(labels[i].substring(1), newNode);
                        } else {
                            node.children.put(labels[i], newNode);
                        }
                        node = newNode;
                    }
                    node.isEnd = true;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isPublicSuffix(String domain) {
        domain = Ascii.toLowerCase(DOTS_MATCHER.replaceFrom(domain, '.'));
        String[] labels = domain.split("\\.");
        int start = domain.charAt(0) == '.' ? 1 : 0;
        int end = domain.charAt(domain.length() - 1) == '.' ? labels.length - 2 : labels.length - 1;
        TrieNode node = this.trie;
        for (int i = end; i >= start; --i) {
            if (node.children != null && node.children.containsKey(labels[i])) {
                node = node.children.get(labels[i]);
                assert (node != null);
            } else {
                return false;
            }
            if (i != 1 || !node.isWildcard) continue;
            if (node.children == null) {
                return true;
            }
            if (!node.children.containsKey(labels[0])) {
                return true;
            }
            TrieNode child = node.children.get(labels[0]);
            assert (child != null);
            return !child.isException;
        }
        return node.isEnd;
    }

    private static final class PublicSuffixHolder {
        private static final PublicSuffix INSTANCE = new PublicSuffix();

        private PublicSuffixHolder() {
        }
    }

    static class TrieNode {
        boolean isEnd;
        boolean isWildcard;
        boolean isException;
        @Nullable
        Map<String, TrieNode> children;

        TrieNode() {
        }
    }
}

