/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.client;

import karate.com.linecorp.armeria.common.FilteredHttpResponse;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.org.reactivestreams.Subscriber;
import karate.org.reactivestreams.Subscription;

public final class TruncatingHttpResponse
extends FilteredHttpResponse {
    private final int maxContentLength;
    private int contentLength;
    private boolean overflow;
    @Nullable
    private Subscriber<? super HttpObject> subscriber;

    public TruncatingHttpResponse(HttpResponse delegate, int maxContentLength) {
        super(delegate);
        this.maxContentLength = maxContentLength;
    }

    @Override
    protected void beforeSubscribe(Subscriber<? super HttpObject> subscriber, Subscription subscription) {
        this.subscriber = subscriber;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (!this.overflow && obj instanceof HttpData) {
            int dataLength = ((HttpData)obj).length();
            this.contentLength += dataLength;
            if (this.contentLength > this.maxContentLength) {
                this.overflow = true;
                assert (this.subscriber != null);
                this.subscriber.onComplete();
            }
        }
        return obj;
    }
}

