/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.client.dns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.AbstractUnwrappable;
import karate.com.linecorp.armeria.common.util.OsType;
import karate.com.linecorp.armeria.common.util.SystemInfo;
import karate.com.linecorp.armeria.common.util.UnmodifiableFuture;
import karate.com.linecorp.armeria.internal.client.dns.ByteArrayDnsRecord;
import karate.com.linecorp.armeria.internal.client.dns.DnsQuestionContext;
import karate.com.linecorp.armeria.internal.client.dns.DnsResolver;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.netty.handler.codec.dns.DnsQuestion;
import karate.io.netty.handler.codec.dns.DnsRecord;
import karate.io.netty.handler.codec.dns.DnsRecordType;
import karate.io.netty.resolver.DefaultHostsFileEntriesResolver;
import karate.io.netty.resolver.HostsFileEntriesResolver;
import karate.io.netty.resolver.ResolvedAddressTypes;
import karate.io.netty.util.NetUtil;

class HostsFileDnsResolver
extends AbstractUnwrappable<DnsResolver>
implements DnsResolver {
    private static final String LOCALHOST = "localhost";
    private static final InetAddress LOCALHOST_ADDRESS = NetUtil.isIpV4StackPreferred() || !SystemInfo.hasIpV6() ? NetUtil.LOCALHOST4 : (NetUtil.isIpV6AddressesPreferred() ? NetUtil.LOCALHOST6 : NetUtil.LOCALHOST4);
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final ResolvedAddressTypes resolvedAddressTypes;

    private static boolean isLocalWindowsHost(String hostname) {
        return SystemInfo.osType() == OsType.WINDOWS && (hostname.equalsIgnoreCase(LOCALHOST) || hostname.equalsIgnoreCase(SystemInfo.hostname()));
    }

    HostsFileDnsResolver(DnsResolver delegate, HostsFileEntriesResolver hostsFileEntriesResolver, ResolvedAddressTypes resolvedAddressTypes) {
        super(delegate);
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        this.resolvedAddressTypes = resolvedAddressTypes;
    }

    @Override
    public CompletableFuture<List<DnsRecord>> resolve(DnsQuestionContext ctx, DnsQuestion question) {
        List<InetAddress> hostsFileEntries;
        DnsRecordType type = question.type();
        String hostname = question.name();
        if ((type == DnsRecordType.A || type == DnsRecordType.AAAA) && (hostsFileEntries = this.resolveHostsFileEntries(hostname)) != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (InetAddress hostsFileEntry : hostsFileEntries) {
                byte[] content = null;
                if (hostsFileEntry instanceof Inet4Address) {
                    if (type == DnsRecordType.A) {
                        content = hostsFileEntry.getAddress();
                    }
                } else if (hostsFileEntry instanceof Inet6Address && type == DnsRecordType.AAAA) {
                    content = hostsFileEntry.getAddress();
                }
                if (content == null) continue;
                builder.add(new ByteArrayDnsRecord(hostname, type, 86400L, content));
            }
            ImmutableCollection records = builder.build();
            if (!records.isEmpty()) {
                return UnmodifiableFuture.completedFuture(records);
            }
        }
        return ((DnsResolver)this.unwrap()).resolve(ctx, question);
    }

    @Nullable
    private List<InetAddress> resolveHostsFileEntries(String hostname) {
        InetAddress address;
        List<InetAddress> addresses = this.hostsFileEntriesResolver instanceof DefaultHostsFileEntriesResolver ? ((DefaultHostsFileEntriesResolver)this.hostsFileEntriesResolver).addresses(hostname, this.resolvedAddressTypes) : ((address = this.hostsFileEntriesResolver.address(hostname, this.resolvedAddressTypes)) != null ? ImmutableList.of(address) : null);
        return addresses == null && HostsFileDnsResolver.isLocalWindowsHost(hostname) ? ImmutableList.of(LOCALHOST_ADDRESS) : addresses;
    }

    @Override
    public void close() {
        ((DnsResolver)this.unwrap()).close();
    }
}

