/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.client.websocket;

import java.util.Objects;
import java.util.function.Consumer;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.io.netty.util.AttributeKey;

public final class WebSocketClientUtil {
    private static final AttributeKey<Consumer<Throwable>> CLOSING_RESPONSE_TASK = AttributeKey.valueOf(WebSocketClientUtil.class, "CLOSING_RESPONSE_TASK");

    public static void setClosingResponseTask(ClientRequestContext ctx, Consumer<Throwable> task) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(task, "task");
        ctx.setAttr(CLOSING_RESPONSE_TASK, task);
    }

    public static void closingResponse(ClientRequestContext ctx, @Nullable Throwable cause) {
        Objects.requireNonNull(ctx, "ctx");
        Consumer<Throwable> task = ctx.attr(CLOSING_RESPONSE_TASK);
        if (task != null) {
            task.accept(cause);
        }
    }

    private WebSocketClientUtil() {
    }
}

