/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import karate.com.linecorp.armeria.common.ByteBufAccessMode;
import karate.com.linecorp.armeria.common.Bytes;
import karate.com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import karate.com.linecorp.armeria.internal.shaded.fastutil.io.FastByteArrayInputStream;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.ByteBufUtil;
import karate.io.netty.buffer.PooledByteBufAllocator;
import karate.io.netty.buffer.Unpooled;

public class ByteArrayBytes
implements Bytes {
    private static final byte[] SAFE_OCTETS = new byte[256];
    private final byte[] array;

    protected ByteArrayBytes(byte[] array) {
        this.array = Objects.requireNonNull(array, "array");
    }

    @Override
    public byte[] array() {
        return this.array;
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public String toString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return new String(this.array, charset);
    }

    public String toString() {
        if (this.array.length == 0) {
            return "{0B}";
        }
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append('{').append(this.array.length).append("B, ");
            String string = ByteArrayBytes.appendPreviews(buf, this.array, 0, Math.min(16, this.array.length)).append('}').toString();
            return string;
        }
    }

    static StringBuilder appendPreviews(StringBuilder buf, byte[] array, int offset, int previewLength) {
        int endOffset = offset + previewLength;
        for (int i = offset; i < endOffset; ++i) {
            if (SAFE_OCTETS[array[i] & 0xFF] != 0) continue;
            return buf.append("hex=").append(ByteBufUtil.hexDump(array, offset, previewLength));
        }
        return buf.append("text=").append(new String(array, 0, offset, previewLength));
    }

    @Override
    public InputStream toInputStream() {
        return new FastByteArrayInputStream(this.array);
    }

    @Override
    public boolean isPooled() {
        return false;
    }

    @Override
    public ByteBuf byteBuf(ByteBufAccessMode mode) {
        Objects.requireNonNull(mode, "mode");
        if (this.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (mode != ByteBufAccessMode.FOR_IO) {
            return Unpooled.wrappedBuffer(this.array);
        }
        ByteBuf copy = this.newDirectByteBuf();
        copy.writeBytes(this.array);
        return copy;
    }

    @Override
    public ByteBuf byteBuf(int offset, int length, ByteBufAccessMode mode) {
        Objects.requireNonNull(mode, "mode");
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (mode != ByteBufAccessMode.FOR_IO) {
            return Unpooled.wrappedBuffer(this.array, offset, length);
        }
        ByteBuf copy = ByteArrayBytes.newDirectByteBuf(length);
        copy.writeBytes(this.array, offset, length);
        return copy;
    }

    private ByteBuf newDirectByteBuf() {
        return ByteArrayBytes.newDirectByteBuf(this.length());
    }

    private static ByteBuf newDirectByteBuf(int length) {
        return PooledByteBufAllocator.DEFAULT.directBuffer(length);
    }

    @Override
    public void close() {
    }

    public int hashCode() {
        int end = Math.min(32, this.length());
        int hash = 0;
        for (int i = 0; i < end; ++i) {
            hash = hash * 31 + this.array[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bytes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Bytes that = (Bytes)obj;
        if (this.length() != that.length()) {
            return false;
        }
        return Arrays.equals(this.array, that.array());
    }

    static {
        String safeOctetStr = "`~!@#$%^&*()-_=+\t[{]}\\|;:'\",<.>/?abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        for (int i = 0; i < "`~!@#$%^&*()-_=+\t[{]}\\|;:'\",<.>/?abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length(); ++i) {
            ByteArrayBytes.SAFE_OCTETS["`~!@#$%^&*()-_=+\t[{]}\\|;:'\",<.>/?abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt((int)i)] = -1;
        }
    }
}

