/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import karate.com.linecorp.armeria.common.ByteBufAccessMode;
import karate.com.linecorp.armeria.common.Bytes;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.ByteArrayBytes;
import karate.com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import karate.com.linecorp.armeria.internal.shaded.fastutil.io.FastByteArrayInputStream;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.ByteBufInputStream;
import karate.io.netty.buffer.ByteBufUtil;
import karate.io.netty.buffer.PooledByteBufAllocator;
import karate.io.netty.util.IllegalReferenceCountException;
import karate.io.netty.util.ResourceLeakHint;

public class ByteBufBytes
implements Bytes,
ResourceLeakHint {
    private final ByteBuf buf;
    private final boolean pooled;
    private boolean closed;
    @Nullable
    private byte[] array;

    protected ByteBufBytes(ByteBuf buf, boolean pooled) {
        this.buf = Objects.requireNonNull(buf, "buf");
        this.pooled = pooled;
    }

    protected ByteBuf buf() {
        return this.buf;
    }

    @Override
    public byte[] array() {
        byte[] bufArray;
        if (this.array != null) {
            return this.array;
        }
        int length = this.buf.readableBytes();
        if (this.pooled) {
            this.buf.touch(this);
        } else if (this.buf.hasArray() && this.buf.arrayOffset() == 0 && this.buf.readerIndex() == 0 && (bufArray = this.buf.array()).length == length) {
            this.array = bufArray;
            return bufArray;
        }
        this.array = ByteBufUtil.getBytes(this.buf, this.buf.readerIndex(), length);
        return this.array;
    }

    @Override
    public int length() {
        return this.buf.readableBytes();
    }

    @Override
    public String toString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        if (this.array != null) {
            return new String(this.array, charset);
        }
        return this.buf.toString(charset);
    }

    public String toString() {
        return this.toString(false);
    }

    /*
     * Unable to fully structure code
     */
    private String toString(boolean hint) {
        length = this.buf.readableBytes();
        tempThreadLocals = TemporaryThreadLocals.acquire();
        try {
            strBuf = tempThreadLocals.stringBuilder();
            strBuf.append('{').append(length).append("B, ");
            if (this.isPooled()) {
                strBuf.append("pooled, ");
            }
            if (this.closed) {
                if (this.buf.refCnt() == 0) {
                    var5_6 = strBuf.append("closed}").toString();
                    return var5_6;
                }
                strBuf.append("closed, ");
            }
            previewLength = Math.min(16, length);
            array = this.array;
            if (array == null) {
                try {
                    if (this.buf.hasArray()) {
                        array = this.buf.array();
                        offset = this.buf.arrayOffset() + this.buf.readerIndex();
                    }
                    if (!hint) {
                        array = ByteBufUtil.getBytes(this.buf, this.buf.readerIndex(), previewLength);
                        offset = 0;
                        if (previewLength != length) ** GOTO lbl36
                        this.array = array;
                    }
                    var8_11 = strBuf.append("<unknown>}").toString();
                    return var8_11;
                }
                catch (IllegalReferenceCountException e) {
                    var9_14 = strBuf.append("badRefCnt}").toString();
                    return var9_14;
                }
            } else {
                offset = 0;
            }
lbl36:
            // 4 sources

            var8_13 = ByteArrayBytes.appendPreviews(strBuf, array, offset, previewLength).append('}').toString();
            return var8_13;
        }
        finally {
            if (tempThreadLocals != null) {
                tempThreadLocals.close();
            }
        }
    }

    @Override
    public String toHintString() {
        return this.toString(true);
    }

    @Override
    public InputStream toInputStream() {
        if (this.array != null) {
            return new FastByteArrayInputStream(this.array);
        }
        return new ByteBufInputStream(this.buf.duplicate(), false);
    }

    @Override
    public boolean isPooled() {
        return this.pooled;
    }

    @Override
    public ByteBuf byteBuf(ByteBufAccessMode mode) {
        switch (Objects.requireNonNull(mode, "mode")) {
            case DUPLICATE: {
                return this.buf.duplicate();
            }
            case RETAINED_DUPLICATE: {
                return this.buf.retainedDuplicate();
            }
            case FOR_IO: {
                if (this.buf.isDirect()) {
                    return this.buf.retainedDuplicate();
                }
                ByteBuf copy = this.newDirectByteBuf();
                copy.writeBytes(this.buf, this.buf.readerIndex(), this.buf.readableBytes());
                return copy;
            }
        }
        throw new Error();
    }

    @Override
    public ByteBuf byteBuf(int offset, int length, ByteBufAccessMode mode) {
        int startIndex = this.buf.readerIndex() + offset;
        switch (Objects.requireNonNull(mode, "mode")) {
            case DUPLICATE: {
                return this.buf.slice(startIndex, length);
            }
            case RETAINED_DUPLICATE: {
                return this.buf.retainedSlice(startIndex, length);
            }
            case FOR_IO: {
                if (this.buf.isDirect()) {
                    return this.buf.retainedSlice(startIndex, length);
                }
                ByteBuf copy = ByteBufBytes.newDirectByteBuf(length);
                copy.writeBytes(this.buf, startIndex, length);
                return copy;
            }
        }
        throw new Error();
    }

    private ByteBuf newDirectByteBuf() {
        return ByteBufBytes.newDirectByteBuf(this.buf.readableBytes());
    }

    private static ByteBuf newDirectByteBuf(int length) {
        return PooledByteBufAllocator.DEFAULT.directBuffer(length);
    }

    @Override
    public void touch(@Nullable Object hint) {
        if (this.isPooled()) {
            this.buf.touch(MoreObjects.firstNonNull(hint, this));
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.pooled) {
                this.buf.release();
            }
        }
    }

    public int hashCode() {
        int hash = 0;
        int bufStart = this.buf.readerIndex();
        int bufEnd = bufStart + Math.min(32, this.buf.readableBytes());
        for (int i = bufStart; i < bufEnd; ++i) {
            hash = hash * 31 + this.buf.getByte(i);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bytes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Bytes that = (Bytes)obj;
        if (this.buf.readableBytes() != that.length()) {
            return false;
        }
        return ByteBufUtil.equals(this.buf, that.byteBuf());
    }
}

