/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common;

import java.util.Set;
import karate.com.fasterxml.jackson.databind.DeserializationFeature;
import karate.com.fasterxml.jackson.databind.ObjectMapper;
import karate.com.fasterxml.jackson.databind.json.JsonMapper;
import karate.com.linecorp.armeria.common.JacksonObjectMapperProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum DefaultJacksonObjectMapperProvider implements JacksonObjectMapperProvider
{
    INSTANCE;

    private static final Logger logger;
    private static boolean noticed;

    @Override
    public ObjectMapper newObjectMapper() {
        JsonMapper.Builder jsonMapperBuilder = JsonMapper.builder();
        jsonMapperBuilder.findAndAddModules();
        Object mapper = jsonMapperBuilder.build();
        Set<Object> registeredModuleIds = ((ObjectMapper)mapper).getRegisteredModuleIds();
        if (registeredModuleIds.contains("karate.com.fasterxml.jackson.module.scala.DefaultScalaModule")) {
            ((ObjectMapper)mapper).enable(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES);
        }
        if (!noticed) {
            if (!registeredModuleIds.isEmpty()) {
                logger.debug("Available Jackson Modules: {}", registeredModuleIds);
            }
            noticed = true;
        }
        return mapper;
    }

    static {
        logger = LoggerFactory.getLogger(DefaultJacksonObjectMapperProvider.class);
    }
}

