/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common;

import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpHeadersBuilder;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.RequestHeadersBuilder;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.ResponseHeadersBuilder;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.common.util.HttpTimestampSupplier;
import karate.io.netty.handler.codec.http.HttpHeaderValues;
import karate.io.netty.util.AsciiString;

public final class HttpHeadersUtil {
    public static final String CLOSE_STRING = HttpHeaderValues.CLOSE.toString();

    public static ResponseHeaders mergeResponseHeaders(ResponseHeaders headers, HttpHeaders additionalHeaders, HttpHeaders defaultHeaders, boolean serverHeaderEnabled, boolean dateHeaderEnabled) {
        if (additionalHeaders.isEmpty() && defaultHeaders.isEmpty() && !serverHeaderEnabled && !dateHeaderEnabled) {
            return headers;
        }
        ResponseHeadersBuilder builder = headers.toBuilder();
        for (AsciiString name : additionalHeaders.names()) {
            if (HttpHeadersUtil.isPseudoHeader(name)) continue;
            builder.remove(name);
            additionalHeaders.forEachValue(name, value -> builder.add((CharSequence)name, (String)value));
        }
        for (AsciiString name : defaultHeaders.names()) {
            if (HttpHeadersUtil.isPseudoHeader(name) || builder.contains(name)) continue;
            defaultHeaders.forEachValue(name, value -> builder.add((CharSequence)name, (String)value));
        }
        if (serverHeaderEnabled && !builder.contains(HttpHeaderNames.SERVER)) {
            builder.add((CharSequence)HttpHeaderNames.SERVER, ArmeriaHttpUtil.SERVER_HEADER);
        }
        if (dateHeaderEnabled && !builder.contains(HttpHeaderNames.DATE)) {
            builder.add((CharSequence)HttpHeaderNames.DATE, HttpTimestampSupplier.currentTime());
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static RequestHeaders mergeRequestHeaders(RequestHeaders headers, HttpHeaders defaultHeaders, HttpHeaders additionalHeaders, HttpHeaders internalHeaders) {
        if (defaultHeaders.isEmpty() && additionalHeaders.isEmpty() && internalHeaders.isEmpty() && headers.contains(HttpHeaderNames.USER_AGENT)) {
            return headers;
        }
        if (defaultHeaders.isEmpty() && additionalHeaders.isEmpty()) {
            boolean containAllInternalHeaders = true;
            for (AsciiString asciiString : internalHeaders.names()) {
                if (headers.contains(asciiString)) continue;
                containAllInternalHeaders = false;
                break;
            }
            if (containAllInternalHeaders) {
                return headers;
            }
        }
        RequestHeadersBuilder builder = headers.toBuilder();
        String authority = additionalHeaders.get(HttpHeaderNames.AUTHORITY);
        if (authority == null) {
            authority = additionalHeaders.get(HttpHeaderNames.HOST);
        }
        if (authority != null) {
            builder.authority(authority);
        }
        for (AsciiString name : additionalHeaders.names()) {
            if (name.equals(HttpHeaderNames.AUTHORITY) || name.equals(HttpHeaderNames.HOST) || ArmeriaHttpUtil.ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST.contains(name)) continue;
            builder.remove(name);
            additionalHeaders.forEachValue(name, value -> builder.add((CharSequence)name, (String)value));
        }
        if (builder.authority() == null) {
            void var6_11;
            String string = defaultHeaders.get(HttpHeaderNames.AUTHORITY);
            if (string == null) {
                String string2 = defaultHeaders.get(HttpHeaderNames.HOST);
            }
            if (var6_11 != null) {
                builder.authority((String)var6_11);
            }
        }
        for (AsciiString name : defaultHeaders.names()) {
            if (name.equals(HttpHeaderNames.AUTHORITY) || name.equals(HttpHeaderNames.HOST) || ArmeriaHttpUtil.ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST.contains(name) || builder.contains(name)) continue;
            defaultHeaders.forEachValue(name, value -> builder.add((CharSequence)name, (String)value));
        }
        if (builder.authority() == null) {
            void var6_16;
            String string = internalHeaders.get(HttpHeaderNames.AUTHORITY);
            if (string == null) {
                String string3 = internalHeaders.get(HttpHeaderNames.HOST);
            }
            if (var6_16 != null) {
                builder.authority((String)var6_16);
            }
        }
        for (AsciiString name : internalHeaders.names()) {
            if (name.equals(HttpHeaderNames.AUTHORITY) || name.equals(HttpHeaderNames.HOST) || ArmeriaHttpUtil.ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST.contains(name) || builder.contains(name)) continue;
            internalHeaders.forEachValue(name, value -> builder.add((CharSequence)name, (String)value));
        }
        return builder.build();
    }

    public static HttpHeaders mergeTrailers(HttpHeaders headers, HttpHeaders additionalTrailers) {
        if (additionalTrailers.isEmpty()) {
            return headers;
        }
        if (headers.isEmpty()) {
            return additionalTrailers;
        }
        HttpHeadersBuilder builder = headers.toBuilder();
        for (AsciiString name : additionalTrailers.names()) {
            if (HttpHeadersUtil.isPseudoHeader(name) || ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            builder.remove(name);
            additionalTrailers.forEachValue(name, value -> builder.add((CharSequence)name, (String)value));
        }
        return builder.build();
    }

    public static String getScheme(SessionProtocol sessionProtocol) {
        if (sessionProtocol.isHttps()) {
            return "https";
        }
        if (sessionProtocol.isHttp()) {
            return "http";
        }
        throw new IllegalArgumentException("sessionProtocol: " + (Object)((Object)sessionProtocol) + " (expected: HTTPS, H2, H1, HTTP, H2C or H1C)");
    }

    public static boolean isPseudoHeader(AsciiString name) {
        return !name.isEmpty() && name.charAt(0) == ':';
    }

    private HttpHeadersUtil() {
    }
}

