/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common;

import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.internal.common.ContextAwareFuture;
import karate.com.linecorp.armeria.internal.common.CurrentJavaVersionSpecific;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaVersionSpecific {
    private static final Logger logger = LoggerFactory.getLogger(JavaVersionSpecific.class);
    private static final JavaVersionSpecific CURRENT = CurrentJavaVersionSpecific.get();

    public static JavaVersionSpecific get() {
        return CURRENT;
    }

    String name() {
        return "Java 8";
    }

    public long currentTimeMicros() {
        return TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
    }

    public <T> CompletableFuture<T> newContextAwareFuture(RequestContext ctx) {
        return new ContextAwareFuture(Objects.requireNonNull(ctx, "ctx"));
    }

    long java9CurrentTimeMicros() {
        Instant now = Clock.systemUTC().instant();
        return TimeUnit.SECONDS.toMicros(now.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(now.getNano());
    }

    static {
        if (CURRENT.getClass() != JavaVersionSpecific.class) {
            logger.info("Using the APIs optimized for: {}", (Object)CURRENT.name());
        }
    }
}

