/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.encoding;

import karate.com.linecorp.armeria.client.encoding.StreamDecoder;
import karate.com.linecorp.armeria.common.ContentTooLargeException;
import karate.com.linecorp.armeria.common.FilteredHttpResponse;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.CompositeException;
import karate.org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpDecodedResponse
extends FilteredHttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpDecodedResponse.class);
    private boolean decoderClosed;

    AbstractHttpDecodedResponse(HttpResponse delegate) {
        super(delegate, true);
    }

    @Nullable
    abstract StreamDecoder decoder();

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        HttpData lastData = this.closeResponseDecoder();
        if (lastData == null) {
            return;
        }
        if (!lastData.isEmpty()) {
            subscriber.onNext(lastData);
        } else {
            lastData.close();
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        try {
            HttpData lastData = this.closeResponseDecoder();
            if (lastData != null) {
                lastData.close();
            }
            return cause;
        }
        catch (Exception decoderException) {
            return new CompositeException(cause, decoderException);
        }
    }

    @Override
    protected void onCancellation(Subscriber<? super HttpObject> subscriber) {
        try {
            HttpData lastData = this.closeResponseDecoder();
            if (lastData != null) {
                lastData.close();
            }
        }
        catch (ContentTooLargeException cause) {
            logger.warn("A response content exceeds the maximum allowed response length.", (Throwable)cause);
        }
    }

    @Nullable
    private HttpData closeResponseDecoder() {
        if (this.decoderClosed) {
            return null;
        }
        this.decoderClosed = true;
        if (this.decoder() == null) {
            return null;
        }
        return this.decoder().finish();
    }
}

