/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.encoding;

import java.io.IOException;
import java.io.OutputStream;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.Unpooled;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.handler.codec.compression.SnappyFrameEncoder;

final class SnappyFramedOutputStream
extends OutputStream {
    private final SimpleSnappyFrameEncoder encoder = new SimpleSnappyFrameEncoder();
    private final ByteBuf out;

    SnappyFramedOutputStream(ByteBuf out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuf input = Unpooled.wrappedBuffer(b, off, len);
        try {
            this.encoder.encode(input, this.out);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failed to compress input with Snappy framing format:", e);
        }
    }

    private static class SimpleSnappyFrameEncoder
    extends SnappyFrameEncoder {
        private SimpleSnappyFrameEncoder() {
        }

        public void encode(ByteBuf in, ByteBuf out) throws Exception {
            this.encode((ChannelHandlerContext)null, in, out);
        }
    }
}

