/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.encoding;

import java.util.Objects;
import javax.annotation.Nonnull;
import karate.com.linecorp.armeria.client.encoding.StreamDecoder;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.ResponseHeadersBuilder;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.encoding.AbstractHttpDecodedResponse;

public final class StaticHttpDecodedResponse
extends AbstractHttpDecodedResponse {
    private final StreamDecoder decoder;
    @Nullable
    private final MediaType contentType;

    public StaticHttpDecodedResponse(HttpResponse delegate, StreamDecoder decoder, @Nullable MediaType contentType) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.decoder = Objects.requireNonNull(decoder, "decoder");
        this.contentType = contentType;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        ResponseHeaders responseHeaders;
        if (obj instanceof HttpData) {
            return this.decoder.decode((HttpData)obj);
        }
        if (obj instanceof ResponseHeaders && !(responseHeaders = (ResponseHeaders)obj).status().isInformational()) {
            ResponseHeadersBuilder builder = responseHeaders.toBuilder();
            builder.remove(HttpHeaderNames.CONTENT_LENGTH);
            if (this.contentType == null) {
                builder.remove(HttpHeaderNames.CONTENT_TYPE);
            } else {
                builder.contentType(this.contentType);
            }
            return builder.build();
        }
        return obj;
    }

    @Override
    @Nonnull
    StreamDecoder decoder() {
        return this.decoder;
    }
}

