/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.metric;

import java.util.Objects;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.logging.RequestLog;
import karate.com.linecorp.armeria.common.logging.RequestLogProperty;
import karate.com.linecorp.armeria.common.logging.RequestOnlyLog;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.micrometer.core.instrument.Tag;

public final class DefaultMeterIdPrefixFunction
implements MeterIdPrefixFunction {
    private final String name;

    public static MeterIdPrefixFunction of(String name) {
        return new DefaultMeterIdPrefixFunction(name);
    }

    private DefaultMeterIdPrefixFunction(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public MeterIdPrefix activeRequestPrefix(MeterRegistry registry, RequestOnlyLog log) {
        ImmutableList.Builder<Tag> tagListBuilder = ImmutableList.builderWithExpectedSize(3);
        DefaultMeterIdPrefixFunction.addActiveRequestPrefixTags(tagListBuilder, log);
        return new MeterIdPrefix(this.name, tagListBuilder.build());
    }

    @Override
    public MeterIdPrefix completeRequestPrefix(MeterRegistry registry, RequestLog log) {
        ImmutableList.Builder<Tag> tagListBuilder = ImmutableList.builderWithExpectedSize(4);
        DefaultMeterIdPrefixFunction.addCompleteRequestPrefixTags(tagListBuilder, log);
        return new MeterIdPrefix(this.name, tagListBuilder.build());
    }

    public static void addActiveRequestPrefixTags(ImmutableList.Builder<Tag> tagListBuilder, RequestOnlyLog log) {
        Objects.requireNonNull(tagListBuilder, "tagListBuilder");
        Objects.requireNonNull(log, "log");
        DefaultMeterIdPrefixFunction.addHostnamePattern(tagListBuilder, log);
        DefaultMeterIdPrefixFunction.addMethodAndService(tagListBuilder, log);
    }

    public static void addCompleteRequestPrefixTags(ImmutableList.Builder<Tag> tagListBuilder, RequestLog log) {
        Objects.requireNonNull(tagListBuilder, "tagListBuilder");
        Objects.requireNonNull(log, "log");
        DefaultMeterIdPrefixFunction.addHostnamePattern(tagListBuilder, log);
        DefaultMeterIdPrefixFunction.addHttpStatus(tagListBuilder, log);
        DefaultMeterIdPrefixFunction.addMethodAndService(tagListBuilder, log);
    }

    public static void addHttpStatus(ImmutableList.Builder<Tag> tagListBuilder, RequestLog log) {
        Objects.requireNonNull(tagListBuilder, "tagListBuilder");
        Objects.requireNonNull(log, "log");
        HttpStatus status = log.isAvailable(RequestLogProperty.RESPONSE_HEADERS) ? log.responseHeaders().status() : HttpStatus.UNKNOWN;
        tagListBuilder.add((Object)Tag.of("http.status", status.codeAsText()));
    }

    private static void addHostnamePattern(ImmutableList.Builder<Tag> tagListBuilder, RequestOnlyLog log) {
        RequestContext ctx = log.context();
        if (ctx instanceof ServiceRequestContext) {
            ServiceRequestContext sCtx = (ServiceRequestContext)ctx;
            tagListBuilder.add((Object)Tag.of("hostname.pattern", sCtx.config().virtualHost().hostnamePattern()));
        }
    }

    private static void addMethodAndService(ImmutableList.Builder<Tag> tagListBuilder, RequestOnlyLog log) {
        tagListBuilder.add((Object)Tag.of("method", log.name()));
        tagListBuilder.add((Object)Tag.of("service", MoreObjects.firstNonNull(log.serviceName(), "none")));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }
}

