/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.stream;

import java.lang.reflect.Field;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.stream.AbortedStreamException;
import karate.org.reactivestreams.Subscriber;
import karate.org.reactivestreams.Subscription;

public final class AbortingSubscriber<T>
implements Subscriber<T> {
    private static final AbortedStreamException ABORTED_STREAM_EXCEPTION_INSTANCE;
    public static final AbortingSubscriber<Object> INSTANCE;
    private final Throwable cause;

    public static <T> AbortingSubscriber<T> get(@Nullable Throwable cause) {
        return cause == null || cause == ABORTED_STREAM_EXCEPTION_INSTANCE ? INSTANCE : new AbortingSubscriber<T>(cause);
    }

    private AbortingSubscriber(Throwable cause) {
        this.cause = cause;
    }

    @Override
    public void onSubscribe(Subscription s) {
        s.cancel();
    }

    @Override
    public void onNext(T o) {
    }

    @Override
    public void onError(Throwable cause) {
    }

    @Override
    public void onComplete() {
    }

    public Throwable cause() {
        return this.cause;
    }

    static {
        try {
            Field field = AbortedStreamException.class.getDeclaredField("INSTANCE");
            field.setAccessible(true);
            ABORTED_STREAM_EXCEPTION_INSTANCE = (AbortedStreamException)field.get(null);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        INSTANCE = new AbortingSubscriber(ABORTED_STREAM_EXCEPTION_INSTANCE);
    }
}

