/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.stream;

import java.util.List;
import java.util.Objects;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.common.stream.AbstractFixedStreamMessage;
import karate.com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;

@UnstableApi
public class RegularFixedStreamMessage<T>
extends AbstractFixedStreamMessage<T> {
    private final T[] objs;

    public RegularFixedStreamMessage(T[] objs) {
        Objects.requireNonNull(objs, "objs");
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] != null) continue;
            throw new NullPointerException("objs[" + i + "] is null");
        }
        this.objs = (Object[])objs.clone();
    }

    @Override
    T get(int index) {
        return this.objs[index];
    }

    @Override
    int size() {
        return this.objs.length;
    }

    @Override
    final List<T> drainAll0(boolean withPooledObjects) {
        int length = this.objs.length;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(length);
        for (T obj : this.objs) {
            builder.add(StreamMessageUtil.touchOrCopyAndClose(obj, withPooledObjects));
        }
        return builder.build();
    }
}

