/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.util;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import karate.com.linecorp.armeria.client.WriteTimeoutException;
import karate.com.linecorp.armeria.common.ClosedSessionException;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.stream.AbortedStreamException;
import karate.com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import karate.com.linecorp.armeria.common.stream.ClosedStreamException;
import karate.com.linecorp.armeria.internal.common.util.ExceptionClassifier;
import karate.com.linecorp.armeria.server.RequestCancellationException;
import karate.io.netty.channel.ChannelException;
import karate.io.netty.handler.codec.http2.Http2Error;
import karate.io.netty.handler.codec.http2.Http2Exception;

public final class DefaultExceptionClassifier
implements ExceptionClassifier {
    private static final Pattern IGNORABLE_SOCKET_ERROR_MESSAGE = Pattern.compile("(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe)", 2);
    private static final Pattern IGNORABLE_HTTP2_ERROR_MESSAGE = Pattern.compile("(?:stream closed)", 2);
    private static final Pattern IGNORABLE_TLS_ERROR_MESSAGE = Pattern.compile("(?:closed already)", 2);

    @Override
    public boolean isExpected(Throwable cause) {
        if (Flags.verboseSocketExceptions()) {
            return false;
        }
        if (cause instanceof ClosedChannelException || cause instanceof ClosedSessionException) {
            return true;
        }
        String msg = cause.getMessage();
        if (msg != null) {
            if ((cause instanceof IOException || cause instanceof ChannelException) && IGNORABLE_SOCKET_ERROR_MESSAGE.matcher(msg).find()) {
                return true;
            }
            if (cause instanceof Http2Exception && IGNORABLE_HTTP2_ERROR_MESSAGE.matcher(msg).find()) {
                return true;
            }
            if (cause instanceof SSLException && IGNORABLE_TLS_ERROR_MESSAGE.matcher(msg).find()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isStreamCancelling(Throwable cause) {
        return cause instanceof ClosedStreamException || cause instanceof CancelledSubscriptionException || cause instanceof RequestCancellationException || cause instanceof WriteTimeoutException || cause instanceof AbortedStreamException || cause instanceof Http2Exception.StreamException && ((Http2Exception.StreamException)cause).error() == Http2Error.CANCEL;
    }
}

