/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.util;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import karate.com.linecorp.armeria.common.TlsKeyPair;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.io.ByteStreams;

public final class KeyStoreUtil {
    public static TlsKeyPair load(File keyStoreFile, @Nullable String keyStorePassword, @Nullable String keyPassword, @Nullable String alias) throws IOException, GeneralSecurityException {
        try (FileInputStream in = new FileInputStream(keyStoreFile);){
            TlsKeyPair tlsKeyPair = KeyStoreUtil.load(in, keyStorePassword, keyPassword, alias, keyStoreFile);
            return tlsKeyPair;
        }
    }

    public static TlsKeyPair load(InputStream keyStoreStream, @Nullable String keyStorePassword, @Nullable String keyPassword, @Nullable String alias) throws IOException, GeneralSecurityException {
        return KeyStoreUtil.load(keyStoreStream, keyStorePassword, keyPassword, alias, null);
    }

    private static TlsKeyPair load(InputStream keyStoreStream, @Nullable String keyStorePassword, @Nullable String keyPassword, @Nullable String alias, @Nullable File keyStoreFile) throws IOException, GeneralSecurityException {
        try (BufferedInputStream in = new BufferedInputStream(keyStoreStream, 8192);){
            ((InputStream)in).mark(4);
            String format = KeyStoreUtil.detectFormat(in);
            ((InputStream)in).reset();
            if (format == null) {
                throw KeyStoreUtil.newException("unknown key store format", keyStoreFile, "(expected: PKCS#12 or JKS format)");
            }
            KeyStore ks = KeyStore.getInstance(format);
            ks.load(in, keyStorePassword != null ? keyStorePassword.toCharArray() : null);
            PrivateKey privateKey = null;
            List certificateChain = null;
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                String candidateAlias = e.nextElement();
                if (alias != null && !alias.equals(candidateAlias) || !ks.isKeyEntry(candidateAlias)) continue;
                PrivateKey candidateKey = (PrivateKey)ks.getKey(candidateAlias, KeyStoreUtil.keyPassword(keyStorePassword, keyPassword));
                Certificate[] candidateCertificateChain = ks.getCertificateChain(candidateAlias);
                if (candidateCertificateChain == null || candidateCertificateChain.length == 0) {
                    throw KeyStoreUtil.newException("the key pair contains no certificate chain", keyStoreFile, "(Specify the alias to choose the right key pair or ensure the key pair has a certificate chain.");
                }
                if (privateKey != null) {
                    throw KeyStoreUtil.newException("found more than one key pair from key store", keyStoreFile, "(Specify the alias to choose the right key pair or use the key store that has only one key pair.)");
                }
                privateKey = candidateKey;
                certificateChain = Arrays.stream(candidateCertificateChain).map(X509Certificate.class::cast).collect(ImmutableList.toImmutableList());
            }
            if (privateKey == null) {
                throw KeyStoreUtil.newException("no key pair found from key store", keyStoreFile, "(Use the key store that has at least one key pair.)");
            }
            assert (certificateChain != null);
            TlsKeyPair tlsKeyPair = TlsKeyPair.of(privateKey, certificateChain);
            return tlsKeyPair;
        }
    }

    @Nullable
    private static String detectFormat(InputStream keyStoreStream) throws IOException {
        byte[] magic = new byte[4];
        try {
            ByteStreams.readFully(keyStoreStream, magic);
        }
        catch (EOFException unused) {
            return null;
        }
        if (magic[0] == 48 && magic[1] == -126) {
            return "PKCS12";
        }
        if (magic[0] == -2 && magic[1] == -19 && magic[2] == -2 && magic[3] == -19) {
            return "JKS";
        }
        return null;
    }

    @Nullable
    private static char[] keyPassword(@Nullable String keyStorePassword, @Nullable String keyPassword) {
        if (keyPassword != null) {
            return keyPassword.toCharArray();
        }
        if (keyStorePassword != null) {
            return keyStorePassword.toCharArray();
        }
        return null;
    }

    private static IllegalArgumentException newException(String message, @Nullable File keyStoreFile, String additionalInfo) {
        if (keyStoreFile != null) {
            return new IllegalArgumentException(message + ": " + keyStoreFile + ' ' + additionalInfo);
        }
        return new IllegalArgumentException(message + ' ' + additionalInfo);
    }

    private KeyStoreUtil() {
    }
}

