/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.util;

import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.DSA;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.EC;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.RSA;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.X509;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import karate.com.linecorp.armeria.internal.shaded.bouncycastle.jce.provider.BouncyCastleProvider;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

public final class MinifiedBouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static final long serialVersionUID = -834653615603942658L;
    static final String BC_PACKAGE_PREFIX = BouncyCastleProvider.class.getName().replaceFirst("\\.bouncycastle\\..*$", ".bouncycastle.");
    private static final String PROVIDER_NAME = "ArmeriaBC";
    private static final ReentrantLock lock = new ReentrantShortLock();
    private static final Map<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter> keyInfoConverters = new ConcurrentHashMap<ASN1ObjectIdentifier, AsymmetricKeyInfoConverter>();

    public static void call(Runnable task) {
        MinifiedBouncyCastleProvider.call(() -> {
            task.run();
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T call(Supplier<T> task) {
        lock.lock();
        boolean needToAdd = true;
        for (Provider provider : Security.getProviders()) {
            if (!(provider instanceof MinifiedBouncyCastleProvider)) continue;
            needToAdd = false;
            break;
        }
        if (needToAdd) {
            Security.addProvider(new MinifiedBouncyCastleProvider());
            T t = task.get();
            return t;
            finally {
                Security.removeProvider(PROVIDER_NAME);
            }
        }
        T t = task.get();
        return t;
        finally {
            lock.unlock();
        }
    }

    public MinifiedBouncyCastleProvider() {
        super(PROVIDER_NAME, 1.0, "Armeria Bouncy Castle Provider");
        AccessController.doPrivileged(() -> {
            this.addFactories();
            return true;
        });
    }

    private void addFactories() {
        new RSA.Mappings().configure(this);
        new DSA.Mappings().configure(this);
        new EC.Mappings().configure(this);
        new X509.Mappings().configure(this);
    }

    public void setParameter(String parameterName, Object parameter) {
    }

    @Override
    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + '.' + name) || this.containsKey("Alg.Alias." + type + '.' + name);
    }

    @Override
    public void addAlgorithm(String key, String value) {
        Preconditions.checkState(!this.containsKey(key), "duplicate algorithm: %s", key);
        if (value.contains(".bouncycastle.")) {
            MinifiedBouncyCastleProvider.checkClassName(value);
        }
        this.put(key, value);
    }

    @Override
    public void addAlgorithm(String type, ASN1ObjectIdentifier oid, String className) {
        MinifiedBouncyCastleProvider.checkClassName(className);
        this.addAlgorithm(type + '.' + oid, className);
        this.addAlgorithm(type + ".OID." + oid, className);
    }

    private static void checkClassName(String className) {
        Preconditions.checkArgument(className.startsWith(BC_PACKAGE_PREFIX), "Unexpected Bouncy Castle class name: %s", (Object)className);
    }

    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        keyInfoConverters.put(oid, keyInfoConverter);
    }

    @Nullable
    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier oid) {
        return keyInfoConverters.get(oid);
    }

    @Override
    public void addAttributes(String key, Map<String, String> attributeMap) {
        for (Map.Entry<String, String> e : attributeMap.entrySet()) {
            String attrKey = key + ' ' + e.getKey();
            Preconditions.checkState(!this.containsKey(attrKey), "duplicate attribute: %s", attrKey);
            this.put(attrKey, e.getValue());
        }
    }
}

