/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.util;

import karate.com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;

public final class TargetLengthBasedClassNameAbbreviator {
    private static final int MAX_DOTS = 16;
    private final int targetLength;

    private static int computeDotIndexes(String className, int[] dotArray) {
        int dotCount;
        int k = 0;
        for (dotCount = 0; (k = className.indexOf(46, k)) != -1 && dotCount < 16; ++dotCount) {
            dotArray[dotCount] = k++;
        }
        return dotCount;
    }

    public TargetLengthBasedClassNameAbbreviator(int targetLength) {
        this.targetLength = targetLength;
    }

    public String abbreviate(String fqClassName) {
        if (fqClassName == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        int inLen = fqClassName.length();
        if (inLen < this.targetLength) {
            return fqClassName;
        }
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            int[] dotIndexesAndLength = tempThreadLocals.intArray(33);
            int dotCount = TargetLengthBasedClassNameAbbreviator.computeDotIndexes(fqClassName, dotIndexesAndLength);
            if (dotCount == 0) {
                String string = fqClassName;
                return string;
            }
            this.computeLengthArray(fqClassName, dotIndexesAndLength, dotCount);
            StringBuilder buf = tempThreadLocals.stringBuilder();
            for (int i = 0; i <= dotCount; ++i) {
                if (i == 0) {
                    buf.append(fqClassName, 0, dotIndexesAndLength[16 + i] - 1);
                    continue;
                }
                buf.append(fqClassName, dotIndexesAndLength[i - 1], dotIndexesAndLength[i - 1] + dotIndexesAndLength[16 + i]);
            }
            String string = buf.toString();
            return string;
        }
    }

    private void computeLengthArray(String className, int[] dotIndexesAndLength, int dotCount) {
        int toTrim = className.length() - this.targetLength;
        for (int i = 0; i < dotCount; ++i) {
            int available;
            int len;
            int previousDotPosition = -1;
            if (i > 0) {
                previousDotPosition = dotIndexesAndLength[i - 1];
            }
            int n = len = (available = dotIndexesAndLength[i] - previousDotPosition - 1) < 1 ? available : 1;
            len = toTrim > 0 ? (available < 1 ? available : 1) : available;
            toTrim -= available - len;
            dotIndexesAndLength[16 + i] = len + 1;
        }
        int lastDotIndex = dotCount - 1;
        dotIndexesAndLength[16 + dotCount] = className.length() - dotIndexesAndLength[lastDotIndex];
    }
}

