/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.util;

import com.google.errorprone.annotations.MustBeClosed;
import karate.com.linecorp.armeria.internal.common.util.EventLoopThread;
import karate.io.netty.util.internal.EmptyArrays;

public final class TemporaryThreadLocals
implements AutoCloseable {
    static final int MAX_BYTE_ARRAY_CAPACITY = 4096;
    static final int MAX_CHAR_ARRAY_CAPACITY = 4096;
    static final int MAX_INT_ARRAY_CAPACITY = 4096;
    static final int MAX_STRING_BUILDER_CAPACITY = 4096;
    private static final ThreadLocal<TemporaryThreadLocals> fallback = ThreadLocal.withInitial(TemporaryThreadLocals::new);
    private boolean lock;
    private byte[] byteArray;
    private char[] charArray;
    private int[] intArray;
    private StringBuilder stringBuilder;

    @MustBeClosed
    public static TemporaryThreadLocals acquire() {
        Thread thread = Thread.currentThread();
        TemporaryThreadLocals tempThreadLocals = thread instanceof EventLoopThread ? ((EventLoopThread)thread).temporaryThreadLocals : fallback.get();
        tempThreadLocals.lock();
        return tempThreadLocals;
    }

    TemporaryThreadLocals() {
        this.clear();
    }

    @Override
    public void close() {
        this.lock = false;
    }

    void clear() {
        this.lock = false;
        this.byteArray = EmptyArrays.EMPTY_BYTES;
        this.charArray = EmptyArrays.EMPTY_CHARS;
        this.intArray = EmptyArrays.EMPTY_INTS;
        this.stringBuilder = TemporaryThreadLocals.inflate(new StringBuilder());
    }

    public byte[] byteArray(int minCapacity) {
        byte[] byteArray = this.byteArray;
        if (byteArray.length >= minCapacity) {
            return byteArray;
        }
        return this.allocateByteArray(minCapacity);
    }

    public char[] charArray(int minCapacity) {
        char[] charArray = this.charArray;
        if (charArray.length >= minCapacity) {
            return charArray;
        }
        return this.allocateCharArray(minCapacity);
    }

    public int[] intArray(int minCapacity) {
        int[] intArray = this.intArray;
        if (intArray.length >= minCapacity) {
            return intArray;
        }
        return this.allocateIntArray(minCapacity);
    }

    public StringBuilder stringBuilder() {
        StringBuilder stringBuilder = this.stringBuilder;
        if (stringBuilder.capacity() > 4096) {
            this.stringBuilder = TemporaryThreadLocals.inflate(new StringBuilder(4096));
            return this.stringBuilder;
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private void lock() {
        assert (!this.lock) : "Cannot be acquired before releasing the resource";
        this.lock = true;
    }

    private byte[] allocateByteArray(int minCapacity) {
        byte[] byteArray = new byte[minCapacity];
        if (minCapacity <= 4096) {
            this.byteArray = byteArray;
        }
        return byteArray;
    }

    private char[] allocateCharArray(int minCapacity) {
        char[] charArray = new char[minCapacity];
        if (minCapacity <= 4096) {
            this.charArray = charArray;
        }
        return charArray;
    }

    private int[] allocateIntArray(int minCapacity) {
        int[] intArray = new int[minCapacity];
        if (minCapacity <= 4096) {
            this.intArray = intArray;
        }
        return intArray;
    }

    private static StringBuilder inflate(StringBuilder stringBuilder) {
        stringBuilder.append('\u0100');
        stringBuilder.setLength(0);
        return stringBuilder;
    }
}

