/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.common.websocket;

import karate.com.linecorp.armeria.common.ByteBufAccessMode;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.websocket.WebSocketFrame;
import karate.com.linecorp.armeria.common.websocket.WebSocketFrameType;
import karate.com.linecorp.armeria.internal.common.websocket.WebSocketUtil;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.buffer.Unpooled;
import karate.io.netty.handler.codec.TooLongFrameException;
import karate.io.netty.util.ReferenceCounted;
import karate.io.netty.util.internal.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketFrameEncoder {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketFrameEncoder.class);
    private static final int GATHERING_WRITE_THRESHOLD = 1024;
    private static final WebSocketFrameEncoder serverEncoder = new WebSocketFrameEncoder(false);
    private static final WebSocketFrameEncoder clientEncoder = new WebSocketFrameEncoder(true);
    private final boolean maskPayload;

    public static WebSocketFrameEncoder of(boolean maskPayload) {
        if (maskPayload) {
            return clientEncoder;
        }
        return serverEncoder;
    }

    private WebSocketFrameEncoder(boolean maskPayload) {
        this.maskPayload = maskPayload;
    }

    public ByteBuf encode(RequestContext ctx, WebSocketFrame msg) {
        try (WebSocketFrame msg0 = msg;){
            ByteBuf byteBuf = this.encode0(ctx, msg0);
            return byteBuf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf encode0(RequestContext ctx, WebSocketFrame msg) {
        WebSocketFrameType type = msg.type();
        int length = msg.length();
        if (type.isControlFrame() && length > 125) {
            throw new TooLongFrameException("the payload length " + length + " of a control frame exceeded the limit 125. frame type: " + (Object)((Object)type));
        }
        logger.trace("Encoding a WebSocket Frame. type: {}, length: {}", (Object)type.opcode(), (Object)length);
        int b0 = 0;
        if (msg.isFinalFragment()) {
            b0 |= 0x80;
        }
        b0 |= type.opcode();
        boolean release = true;
        ReferenceCounted buf = null;
        try {
            int size;
            int maskLength;
            int n = maskLength = this.maskPayload ? 4 : 0;
            if (length <= 125) {
                size = 2 + maskLength + length;
                buf = ctx.alloc().buffer(size);
                ((ByteBuf)buf).writeByte(b0);
                byte b = this.maskPayload ? (byte)(0x80 | (byte)length) : (byte)length;
                ((ByteBuf)buf).writeByte(b);
            } else if (length <= 65535) {
                size = 4 + maskLength;
                if (this.maskPayload || length <= 1024) {
                    size += length;
                }
                buf = ctx.alloc().buffer(size);
                ((ByteBuf)buf).writeByte(b0);
                ((ByteBuf)buf).writeByte(this.maskPayload ? 254 : 126);
                ((ByteBuf)buf).writeByte(length >>> 8 & 0xFF);
                ((ByteBuf)buf).writeByte(length & 0xFF);
            } else {
                size = 10 + maskLength;
                if (this.maskPayload) {
                    size += length;
                }
                buf = ctx.alloc().buffer(size);
                ((ByteBuf)buf).writeByte(b0);
                ((ByteBuf)buf).writeByte(this.maskPayload ? 255 : 127);
                ((ByteBuf)buf).writeLong(length);
            }
            if (this.maskPayload) {
                int i;
                int mask = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
                ((ByteBuf)buf).writeInt(mask);
                long longMask = (long)mask & 0xFFFFFFFFL;
                longMask |= longMask << 32;
                ByteBuf data = msg.byteBuf();
                int end = data.writerIndex();
                int lim = end - 7;
                for (i = data.readerIndex(); i < lim; i += 8) {
                    ((ByteBuf)buf).writeLong(data.getLong(i) ^ longMask);
                }
                if (i < end - 3) {
                    ((ByteBuf)buf).writeInt(data.getInt(i) ^ (int)longMask);
                    i += 4;
                }
                int maskOffset = 0;
                while (i < end) {
                    byte byteData = data.getByte(i);
                    ((ByteBuf)buf).writeByte(byteData ^ WebSocketUtil.byteAtIndex(mask, maskOffset++ & 3));
                    ++i;
                }
            } else if (((ByteBuf)buf).writableBytes() >= msg.length()) {
                ((ByteBuf)buf).writeBytes(msg.byteBuf());
            } else {
                buf = Unpooled.wrappedBuffer(new ByteBuf[]{buf, msg.byteBuf(ByteBufAccessMode.FOR_IO)});
            }
            release = false;
            ReferenceCounted referenceCounted = buf;
            return referenceCounted;
        }
        finally {
            if (release && buf != null) {
                buf.release();
            }
        }
    }
}

