/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.logging;

import java.util.Objects;
import java.util.function.BiFunction;
import karate.com.linecorp.armeria.common.FilteredHttpRequest;
import karate.com.linecorp.armeria.common.FilteredHttpResponse;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.ContentPreviewer;
import karate.com.linecorp.armeria.common.logging.ContentPreviewerFactory;
import karate.com.linecorp.armeria.common.logging.RequestLogBuilder;
import karate.com.linecorp.armeria.common.logging.RequestLogProperty;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentPreviewingUtil {
    private static final Logger logger = LoggerFactory.getLogger(ContentPreviewingUtil.class);

    public static HttpRequest setUpRequestContentPreviewer(RequestContext ctx, HttpRequest req, final ContentPreviewer requestContentPreviewer, BiFunction<? super RequestContext, String, ? extends @Nullable Object> contentSanitizer) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(req, "req");
        Objects.requireNonNull(requestContentPreviewer, "requestContentPreviewer");
        Objects.requireNonNull(contentSanitizer, "contentSanitizer");
        if (requestContentPreviewer.isDisabled()) {
            return req;
        }
        RequestLogBuilder logBuilder = ctx.logBuilder();
        logBuilder.defer(RequestLogProperty.REQUEST_CONTENT_PREVIEW);
        FilteredHttpRequest filteredHttpRequest = new FilteredHttpRequest(req){

            @Override
            protected HttpObject filter(HttpObject obj) {
                if (obj instanceof HttpData) {
                    requestContentPreviewer.onData((HttpData)obj);
                }
                return obj;
            }
        };
        filteredHttpRequest.whenComplete().handle((unused, cause) -> {
            String produced = null;
            try {
                produced = requestContentPreviewer.produce();
                if (produced != null) {
                    produced = ContentPreviewingUtil.sanitize(contentSanitizer, ctx, produced);
                }
            }
            catch (Exception e) {
                logger.warn("Unexpected exception while producing the request content preview. previewer: {}", (Object)requestContentPreviewer, (Object)e);
            }
            logBuilder.requestContentPreview(produced);
            return null;
        });
        return filteredHttpRequest;
    }

    public static HttpResponse setUpResponseContentPreviewer(ContentPreviewerFactory factory, RequestContext ctx, HttpResponse res, BiFunction<? super RequestContext, String, ? extends @Nullable Object> contentSanitizer) {
        Objects.requireNonNull(factory, "factory");
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(res, "res");
        Objects.requireNonNull(contentSanitizer, "contentSanitizer");
        return new ContentPreviewerHttpResponse(res, factory, ctx, contentSanitizer);
    }

    private ContentPreviewingUtil() {
    }

    @Nullable
    private static String sanitize(BiFunction<? super RequestContext, String, ? extends @Nullable Object> contentSanitizer, RequestContext ctx, String produced) {
        Object sanitized = contentSanitizer.apply(ctx, produced);
        return sanitized != null ? sanitized.toString() : "<sanitized>";
    }

    private static class ContentPreviewerHttpResponse
    extends FilteredHttpResponse {
        private final ContentPreviewerFactory factory;
        private final RequestContext ctx;
        @Nullable
        ContentPreviewer responseContentPreviewer;

        protected ContentPreviewerHttpResponse(HttpResponse delegate, ContentPreviewerFactory factory, RequestContext ctx, BiFunction<? super RequestContext, String, ? extends @Nullable Object> contentSanitizer) {
            super(delegate);
            this.factory = factory;
            this.ctx = ctx;
            this.whenComplete().handle((unused, cause) -> {
                if (this.responseContentPreviewer != null) {
                    String produced = null;
                    try {
                        produced = this.responseContentPreviewer.produce();
                        if (produced != null) {
                            produced = ContentPreviewingUtil.sanitize(contentSanitizer, ctx, produced);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Unexpected exception while producing the response content preview. previewer: {}", (Object)this.responseContentPreviewer, (Object)e);
                    }
                    ctx.logBuilder().responseContentPreview(produced);
                } else {
                    ctx.logBuilder().responseContentPreview(null);
                }
                return null;
            });
        }

        @Override
        protected HttpObject filter(HttpObject obj) {
            if (obj instanceof ResponseHeaders) {
                ResponseHeaders resHeaders = (ResponseHeaders)obj;
                String status = resHeaders.get(HttpHeaderNames.STATUS);
                if (ArmeriaHttpUtil.isInformational(status)) {
                    return obj;
                }
                ContentPreviewer contentPreviewer = this.factory.responseContentPreviewer(this.ctx, resHeaders);
                if (!contentPreviewer.isDisabled()) {
                    this.responseContentPreviewer = contentPreviewer;
                }
            } else if (obj instanceof HttpData && this.responseContentPreviewer != null) {
                this.responseContentPreviewer.onData((HttpData)obj);
            }
            return obj;
        }
    }
}

