/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.internal.server;

import java.util.Set;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpHeadersBuilder;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Strings;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.cors.CorsConfig;
import karate.com.linecorp.armeria.server.cors.CorsPolicy;
import karate.com.linecorp.armeria.server.cors.CorsService;
import karate.io.netty.util.AsciiString;
import karate.io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorsHeaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(CorsHeaderUtil.class);
    public static final String ANY_ORIGIN = "*";
    public static final String NULL_ORIGIN = "null";
    public static final String DELIMITER = ",";
    private static final Joiner HEADER_JOINER = Joiner.on(",");
    private static final AttributeKey<Boolean> IS_CORS_SET = AttributeKey.valueOf(CorsService.class, "IS_CORS_SET");

    public static void setCorsResponseHeaders(ServiceRequestContext ctx, HttpRequest req, HttpHeadersBuilder headers, CorsConfig config) {
        CorsPolicy policy = CorsHeaderUtil.setCorsOrigin(ctx, req, headers, config);
        if (policy != null) {
            CorsHeaderUtil.setCorsAllowCredentials(headers, policy);
            CorsHeaderUtil.setCorsAllowHeaders(req.headers(), headers, policy);
            CorsHeaderUtil.setCorsExposeHeaders(headers, policy);
        }
    }

    public static void setCorsAllowCredentials(HttpHeadersBuilder headers, CorsPolicy policy) {
        if (policy.isCredentialsAllowed() && !ANY_ORIGIN.equals(headers.get(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN))) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
    }

    private static void setCorsExposeHeaders(HttpHeadersBuilder headers, CorsPolicy corsPolicy) {
        if (corsPolicy.exposedHeaders().isEmpty()) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, CorsHeaderUtil.joinExposedHeaders(corsPolicy));
    }

    public static void setCorsAllowHeaders(RequestHeaders requestHeaders, HttpHeadersBuilder headers, CorsPolicy corsPolicy) {
        if (corsPolicy.shouldAllowAllRequestHeaders()) {
            String header = requestHeaders.get(HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS);
            if (!Strings.isNullOrEmpty(header)) {
                headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, header);
            }
            return;
        }
        if (corsPolicy.allowedRequestHeaders().isEmpty()) {
            return;
        }
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, CorsHeaderUtil.joinAllowedRequestHeaders(corsPolicy));
    }

    @Nullable
    public static CorsPolicy setCorsOrigin(ServiceRequestContext ctx, HttpRequest request, HttpHeadersBuilder headers, CorsConfig config) {
        String origin = request.headers().get(HttpHeaderNames.ORIGIN);
        if (origin != null) {
            CorsPolicy policy = config.getPolicy(origin, ctx.routingContext());
            if (policy == null) {
                logger.debug("{} There is no CORS policy configured for the request origin '{}' and the path '{}'.", new Object[]{ctx, origin, ctx.path()});
                return null;
            }
            if (NULL_ORIGIN.equals(origin)) {
                CorsHeaderUtil.setCorsNullOrigin(headers);
                return policy;
            }
            if (config.isAnyOriginSupported()) {
                if (policy.isCredentialsAllowed()) {
                    CorsHeaderUtil.echoCorsRequestOrigin(request, headers);
                    CorsHeaderUtil.addCorsVaryHeader(headers);
                } else {
                    CorsHeaderUtil.setCorsAnyOrigin(headers);
                }
                return policy;
            }
            CorsHeaderUtil.setCorsOrigin(headers, origin);
            CorsHeaderUtil.addCorsVaryHeader(headers);
            return policy;
        }
        return null;
    }

    private static void setCorsOrigin(HttpHeadersBuilder headers, String origin) {
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, origin);
    }

    private static void echoCorsRequestOrigin(HttpRequest request, HttpHeadersBuilder headers) {
        String origin = request.headers().get(HttpHeaderNames.ORIGIN);
        if (origin != null) {
            CorsHeaderUtil.setCorsOrigin(headers, origin);
        }
    }

    private static void addCorsVaryHeader(HttpHeadersBuilder headers) {
        headers.add((CharSequence)HttpHeaderNames.VARY, HttpHeaderNames.ORIGIN.toString());
    }

    private static void setCorsAnyOrigin(HttpHeadersBuilder headers) {
        CorsHeaderUtil.setCorsOrigin(headers, ANY_ORIGIN);
    }

    private static void setCorsNullOrigin(HttpHeadersBuilder headers) {
        CorsHeaderUtil.setCorsOrigin(headers, NULL_ORIGIN);
    }

    private static String joinHeaders(Set<AsciiString> headers) {
        return HEADER_JOINER.join(headers);
    }

    private static String joinExposedHeaders(CorsPolicy policy) {
        return CorsHeaderUtil.joinHeaders(policy.exposedHeaders());
    }

    private static String joinAllowedRequestHeaders(CorsPolicy corsPolicy) {
        return CorsHeaderUtil.joinHeaders(corsPolicy.allowedRequestHeaders());
    }

    public static boolean isForbiddenOrigin(CorsConfig config, ServiceRequestContext ctx, RequestHeaders req) {
        return config.isShortCircuit() && config.getPolicy(req.get(HttpHeaderNames.ORIGIN), ctx.routingContext()) == null;
    }

    public static boolean isCorsHeadersSet(ServiceRequestContext ctx) {
        return ctx.hasAttr(IS_CORS_SET);
    }

    public static void corsHeadersSet(ServiceRequestContext ctx) {
        ctx.setAttr(IS_CORS_SET, true);
    }

    private CorsHeaderUtil() {
    }
}

